/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.storage.sql.RowId;

public class Invalidations
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARENT = "__PARENT__";
    public static final String SERIES_PROXIES = "__SERIES_PROXIES__";
    public static final String TARGET_PROXIES = "__TARGET_PROXIES__";
    public static final int MODIFIED = 1;
    public static final int DELETED = 2;
    public boolean all;
    public Set<RowId> modified;
    public Set<RowId> deleted;

    public Invalidations() {
    }

    public Invalidations(boolean all) {
        this.all = all;
    }

    public boolean isEmpty() {
        return this.modified == null && this.deleted == null && !this.all;
    }

    public void clear() {
        this.all = false;
        this.modified = null;
        this.deleted = null;
    }

    public Set<RowId> getKindSet(int kind) {
        switch (kind) {
            case 1: {
                if (this.modified == null) {
                    this.modified = new HashSet<RowId>();
                }
                return this.modified;
            }
            case 2: {
                if (this.deleted == null) {
                    this.deleted = new HashSet<RowId>();
                }
                return this.deleted;
            }
        }
        throw new AssertionError();
    }

    public void add(Invalidations other) {
        if (other == null) {
            return;
        }
        if (this.all) {
            return;
        }
        if (other.all) {
            this.all = true;
            this.modified = null;
            this.deleted = null;
            return;
        }
        if (other.modified != null) {
            this.addModified(other.modified);
        }
        if (other.deleted != null) {
            this.addDeleted(other.deleted);
        }
    }

    public void addModified(RowId rowId) {
        if (this.all) {
            return;
        }
        if (this.modified == null) {
            this.modified = new HashSet<RowId>();
        }
        this.modified.add(rowId);
    }

    protected void addModified(Set<RowId> rowIds) {
        if (this.modified == null) {
            this.modified = new HashSet<RowId>();
        }
        this.modified.addAll(rowIds);
    }

    public void addDeleted(RowId rowId) {
        if (this.all) {
            return;
        }
        if (this.deleted == null) {
            this.deleted = new HashSet<RowId>();
        }
        this.deleted.add(rowId);
    }

    protected void addDeleted(Set<RowId> rowIds) {
        if (this.deleted == null) {
            this.deleted = new HashSet<RowId>();
        }
        this.deleted.addAll(rowIds);
    }

    public void add(Serializable id, String[] tableNames, int kind) {
        if (tableNames.length == 0) {
            return;
        }
        Set<RowId> set = this.getKindSet(kind);
        for (String tableName : tableNames) {
            set.add(new RowId(tableName, id));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + '(');
        if (this.all) {
            sb.append("all=true");
        }
        if (this.modified != null) {
            sb.append("modified=");
            sb.append(this.modified);
            if (this.deleted != null) {
                sb.append(',');
            }
        }
        if (this.deleted != null) {
            sb.append("deleted=");
            sb.append(this.deleted);
        }
        sb.append(')');
        return sb.toString();
    }

    public static final class InvalidationsPair
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Invalidations cacheInvalidations;
        public final Invalidations eventInvalidations;

        public InvalidationsPair(Invalidations cacheInvalidations, Invalidations eventInvalidations) {
            this.cacheInvalidations = cacheInvalidations;
            this.eventInvalidations = eventInvalidations;
        }
    }
}

