/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepositoryService;
import org.nuxeo.runtime.api.Framework;

public class SoftDeleteCleanupListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SoftDeleteCleanupListener.class);
    public static final int DEFAULT_MAX = 1000;
    public static final String DEFAULT_MAX_PROP = "org.nuxeo.vcs.softdelete.cleanup.max";
    public static final int DEFAULT_DELAY = 300;
    public static final String DEFAULT_DELAY_PROP = "org.nuxeo.vcs.softdelete.cleanup.age";

    protected int getMax() {
        String max = Framework.getProperty((String)DEFAULT_MAX_PROP);
        if (max == null) {
            return 1000;
        }
        try {
            return Integer.parseInt(max);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid property org.nuxeo.vcs.softdelete.cleanup.max", (Throwable)e);
            return 1000;
        }
    }

    protected int getDelaySeconds() {
        String delay = Framework.getProperty((String)DEFAULT_DELAY_PROP);
        if (delay == null) {
            return 300;
        }
        try {
            return Integer.parseInt(delay);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Invalid property org.nuxeo.vcs.softdelete.cleanup.age", (Throwable)e);
            return 300;
        }
    }

    public void handleEvent(Event event) {
        Calendar beforeTime;
        int max = this.getMax();
        int delay = this.getDelaySeconds();
        if (delay <= 0) {
            beforeTime = null;
        } else {
            beforeTime = Calendar.getInstance();
            beforeTime.add(13, -delay);
        }
        SQLRepositoryService sqlRepositoryService = (SQLRepositoryService)((Object)Framework.getService(SQLRepositoryService.class));
        for (RepositoryManagement repoMgmt : sqlRepositoryService.getRepositories()) {
            log.debug((Object)("Calling repository soft-delete cleanup for repository: " + repoMgmt.getName() + ", max=" + max + ", beforeTimeDelay=" + delay));
            int n = repoMgmt.cleanupDeletedDocuments(max, beforeTime);
            log.debug((Object)("Number of documents deleted: " + n));
        }
    }
}

