/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.storage.sql.jdbc.NXQLQueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class QueryMakerServiceImpl
extends DefaultComponent
implements QueryMakerService {
    private static final Log log = LogFactory.getLog(QueryMakerServiceImpl.class);
    public static final String XP = "queryMaker";
    protected final List<QueryMakerDescriptor> descriptors = new ArrayList<QueryMakerDescriptor>(2);
    protected List<Class<? extends QueryMaker>> queryMakers;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP.equals(extensionPoint)) {
            this.registerQueryMaker((QueryMakerDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP.equals(extensionPoint)) {
            this.unregisterQueryMaker((QueryMakerDescriptor)contribution);
        }
    }

    @Override
    public void registerQueryMaker(QueryMakerDescriptor descriptor) {
        if (descriptor.enabled) {
            log.info((Object)String.format("Registering QueryMaker '%s': %s", descriptor.name, descriptor.queryMaker.getName()));
        } else {
            log.info((Object)String.format("Disabling QueryMaker '%s'", descriptor.name));
        }
        this.descriptors.add(descriptor);
        this.queryMakers = null;
    }

    @Override
    public void unregisterQueryMaker(QueryMakerDescriptor descriptor) {
        if (descriptor.enabled) {
            log.info((Object)String.format("Unregistering QueryMaker '%s': %s", descriptor.name, descriptor.queryMaker.getName()));
        } else {
            log.info((Object)String.format("Unregistering disabled QueryMaker '%s'", descriptor.name));
        }
        this.descriptors.remove(descriptor);
        this.queryMakers = null;
    }

    @Override
    public synchronized List<Class<? extends QueryMaker>> getQueryMakers() {
        if (this.queryMakers == null) {
            this.queryMakers = new ArrayList<Class<? extends QueryMaker>>(2);
            ArrayList<QueryMakerDescriptor> qmdl = new ArrayList<QueryMakerDescriptor>(this.descriptors);
            Collections.reverse(qmdl);
            HashSet<String> done = new HashSet<String>();
            for (QueryMakerDescriptor descriptor : qmdl) {
                if (!done.add(descriptor.name) || !descriptor.enabled) continue;
                this.queryMakers.add(descriptor.queryMaker);
            }
            Collections.reverse(this.queryMakers);
            if (this.queryMakers.isEmpty() && !done.contains("NXQL")) {
                this.queryMakers.add(NXQLQueryMaker.class);
            }
        }
        return this.queryMakers;
    }
}

