/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.io.UnsupportedEncodingException;

public class Conversion {
    public static byte[] convertToByteArray(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static byte[] convertToByteArray(byte n) {
        n = (byte)(n ^ 0xFFFFFF80);
        return new byte[]{n};
    }

    public static byte[] convertToByteArray(short n) {
        n = (short)(n ^ Short.MIN_VALUE);
        byte[] key = new byte[2];
        Conversion.pack2(key, 0, n);
        return key;
    }

    public static byte[] convertToByteArray(int n) {
        byte[] key = new byte[4];
        Conversion.pack4(key, 0, n ^= Integer.MIN_VALUE);
        return key;
    }

    public static byte[] convertToByteArray(long n) {
        byte[] key = new byte[8];
        Conversion.pack8(key, 0, n ^= Long.MIN_VALUE);
        return key;
    }

    public static String convertToString(byte[] buf) {
        try {
            return new String(buf, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
            throw new Error("Platform doesn't support UTF8 encoding");
        }
    }

    public static int convertToInt(byte[] buf) {
        int value = Conversion.unpack4(buf, 0);
        return value ^= Integer.MIN_VALUE;
    }

    public static long convertToLong(byte[] buf) {
        long value = ((long)Conversion.unpack4(buf, 0) << 32) + ((long)Conversion.unpack4(buf, 4) & 0xFFFFFFFFL);
        return value ^= Long.MIN_VALUE;
    }

    static int unpack4(byte[] buf, int offset) {
        int value = buf[offset] << 24 | buf[offset + 1] << 16 & 0xFF0000 | buf[offset + 2] << 8 & 0xFF00 | buf[offset + 3] << 0 & 0xFF;
        return value;
    }

    static final void pack2(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack4(byte[] data, int offs, int val) {
        data[offs++] = (byte)(val >> 24);
        data[offs++] = (byte)(val >> 16);
        data[offs++] = (byte)(val >> 8);
        data[offs++] = (byte)val;
    }

    static final void pack8(byte[] data, int offs, long val) {
        Conversion.pack4(data, 0, (int)(val >> 32));
        Conversion.pack4(data, 4, (int)val);
    }

    public static void main(String[] args) {
        byte[] buf = Conversion.convertToByteArray(5);
        System.out.println("int value of 5 is: " + Conversion.convertToInt(buf));
        buf = Conversion.convertToByteArray(-1);
        System.out.println("int value of -1 is: " + Conversion.convertToInt(buf));
        buf = Conversion.convertToByteArray(22111000);
        System.out.println("int value of 22111000 is: " + Conversion.convertToInt(buf));
        buf = Conversion.convertToByteArray(5L);
        System.out.println("long value of 5 is: " + Conversion.convertToLong(buf));
        buf = Conversion.convertToByteArray(-1L);
        System.out.println("long value of -1 is: " + Conversion.convertToLong(buf));
        buf = Conversion.convertToByteArray(1112223334445556667L);
        System.out.println("long value of 1112223334445556667 is: " + Conversion.convertToLong(buf));
    }
}

