/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Tokenizer;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Tokenizer tokenizer = new Tokenizer();
    String tableName = null;
    String schemaName = null;
    int statementType;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public void setSource(String string) throws HsqlException {
        this.tokenizer.reset(string);
        this.statementType = 1;
        String string2 = this.tokenizer.getString();
        if (string2.equals("INSERT")) {
            this.statementType = 3;
            this.tokenizer.getString();
            this.tableName = this.tokenizer.getString();
            this.tokenizer.getString();
        } else if (string2.equals("DELETE")) {
            this.statementType = 2;
            this.tokenizer.getString();
            this.tableName = this.tokenizer.getString();
        } else if (string2.equals("COMMIT")) {
            this.statementType = 5;
        } else if (string2.equals("SET") && this.tokenizer.isGetThis("SCHEMA")) {
            this.schemaName = this.tokenizer.getSimpleName();
            this.statementType = 7;
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected String readField() throws IOException {
        try {
            this.tokenizer.getString();
            if (this.statementType == 2) {
                this.tokenizer.getString();
                this.tokenizer.getString();
            }
            String string = this.tokenizer.getString();
            if (this.tokenizer.getType() == 0) {
                string = null;
            }
            return string;
        }
        catch (HsqlException hsqlException) {
            throw new IOException(hsqlException.getMessage());
        }
    }

    protected String readNumberField() throws IOException {
        try {
            String string;
            this.tokenizer.getString();
            if (this.statementType == 2) {
                this.tokenizer.getString();
                this.tokenizer.getString();
            }
            if ("-".equals(string = this.tokenizer.getString())) {
                string = string + this.tokenizer.getString();
            } else if (this.tokenizer.getType() == 0) {
                string = null;
            }
            return string;
        }
        catch (HsqlException hsqlException) {
            throw new IOException(hsqlException.getMessage());
        }
    }

    public String readString() throws IOException {
        String string = this.readField();
        return ValuePool.getString(string);
    }

    public short readShortData() throws IOException {
        String string = this.readNumberField();
        if (string == null) {
            return 0;
        }
        return Short.parseShort(string);
    }

    public int readIntData() throws IOException {
        String string = this.readNumberField();
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public long readLongData() throws IOException {
        String string = this.readNumberField();
        if (string == null) {
            return 0L;
        }
        return Long.parseLong(string);
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean checkNull() {
        return false;
    }

    protected String readChar(int n) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        String string = this.readNumberField();
        if (string == null) {
            return null;
        }
        int n = Integer.parseInt(string);
        return ValuePool.getInt(n);
    }

    protected Integer readInteger() throws IOException, HsqlException {
        String string = this.readNumberField();
        if (string == null) {
            return null;
        }
        int n = Integer.parseInt(string);
        return ValuePool.getInt(n);
    }

    protected Long readBigint() throws IOException, HsqlException {
        String string = this.readNumberField();
        if (string == null) {
            return null;
        }
        long l = Long.parseLong(string);
        return ValuePool.getLong(l);
    }

    protected Double readReal(int n) throws IOException, HsqlException {
        String string = this.readNumberField();
        if (string == null) {
            return null;
        }
        double d = Double.parseDouble(string);
        if (this.tokenizer.isGetThis("/")) {
            string = this.tokenizer.getString();
            double d2 = Double.parseDouble(string);
            if (d == 0.0) {
                d = Double.NaN;
            } else if (d == -1.0) {
                d = Double.NEGATIVE_INFINITY;
            } else if (d == 1.0) {
                d = Double.POSITIVE_INFINITY;
            }
        }
        return ValuePool.getDouble(Double.doubleToLongBits(d));
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        String string = this.readNumberField();
        if (string == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return ValuePool.getBigDecimal(bigDecimal);
    }

    protected Time readTime() throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        return HsqlDateTime.timeValue(string);
    }

    protected Date readDate() throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        return HsqlDateTime.dateValue(string);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        return HsqlDateTime.timestampValue(string);
    }

    protected Boolean readBit() throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        return string.equalsIgnoreCase("TRUE") ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object readOther() throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        byte[] byArray = Column.hexToByteArray(string);
        return new JavaObject(byArray);
    }

    protected Binary readBinary(int n) throws IOException, HsqlException {
        String string = this.readField();
        if (string == null) {
            return null;
        }
        return new Binary(Column.hexToByteArray(string), false);
    }
}

