/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.plugins.text.extractors.UnclosableZipInputStream;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlZip2TextConverter
implements Converter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setValidating(false);
        try {
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            StringBuilder sb = new StringBuilder();
            UnclosableZipInputStream zis = new UnclosableZipInputStream(blobHolder.getBlob().getStream());
            try {
                this.readXmlZipContent(zis, reader, sb);
            }
            finally {
                zis.doClose();
            }
            return new SimpleCachableBlobHolder((Blob)new StringBlob(sb.toString()));
        }
        catch (Exception e) {
            throw new ConversionException("Error during OpenXml2Text conversion", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }

    protected abstract void readXmlZipContent(ZipInputStream var1, XMLReader var2, StringBuilder var3) throws IOException, SAXException;
}

