/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.api.ConverterNotAvailable;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.convert.cache.CacheKeyGenerator;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheHolder;
import org.nuxeo.ecm.core.convert.extension.ChainedConverter;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.core.convert.extension.GlobalConfigDescriptor;
import org.nuxeo.ecm.core.convert.service.MimeTypeTranslationHelper;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ConversionServiceImpl
extends DefaultComponent
implements ConversionService {
    private static final Log log = LogFactory.getLog(ConversionServiceImpl.class);
    public static final String CONVERTER_EP = "converter";
    public static final String CONFIG_EP = "configuration";
    protected static final Map<String, ConverterDescriptor> converterDescriptors = new HashMap<String, ConverterDescriptor>();
    protected static final MimeTypeTranslationHelper translationHelper = new MimeTypeTranslationHelper();
    protected static final GlobalConfigDescriptor config = new GlobalConfigDescriptor();
    protected final Map<String, ConverterCheckResult> checkResultCache = new HashMap<String, ConverterCheckResult>();

    public void activate(ComponentContext context) throws Exception {
        converterDescriptors.clear();
        translationHelper.clear();
    }

    public void deactivate(ComponentContext context) throws Exception {
        converterDescriptors.clear();
        translationHelper.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONVERTER_EP.equals(extensionPoint)) {
            ConverterDescriptor desc = (ConverterDescriptor)contribution;
            ConversionServiceImpl.registerConverter(desc);
        } else if (CONFIG_EP.equals(extensionPoint)) {
            GlobalConfigDescriptor desc = (GlobalConfigDescriptor)contribution;
            config.update(desc);
        } else {
            log.error((Object)("Unable to handle unknown extensionPoint " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
    }

    public static Converter getConverter(String converterName) {
        ConverterDescriptor desc = converterDescriptors.get(converterName);
        if (desc == null) {
            return null;
        }
        return desc.getConverterInstance();
    }

    public static ConverterDescriptor getConverterDescriptor(String converterName) {
        return converterDescriptors.get(converterName);
    }

    public static long getGCIntervalInMinutes() {
        return config.getGCInterval();
    }

    public static void registerConverter(ConverterDescriptor desc) {
        if (converterDescriptors.containsKey(desc.getConverterName())) {
            ConverterDescriptor existing = converterDescriptors.get(desc.getConverterName());
            desc = existing.merge(desc);
        }
        try {
            desc.initConverter();
        }
        catch (Exception e) {
            log.error((Object)("Unable to init converter " + desc.getConverterName()), (Throwable)e);
            return;
        }
        translationHelper.addConverter(desc);
        converterDescriptors.put(desc.getConverterName(), desc);
    }

    public static int getMaxCacheSizeInKB() {
        return config.getDiskCacheSize();
    }

    public static void setMaxCacheSizeInKB(int size) {
        config.setDiskCacheSize(size);
    }

    public static boolean isCacheEnabled() {
        return config.isCacheEnabled();
    }

    public static String getCacheBasePath() {
        return config.getCachingDirectory();
    }

    public List<String> getRegistredConverters() {
        ArrayList<String> converterNames = new ArrayList<String>();
        converterNames.addAll(converterDescriptors.keySet());
        return converterNames;
    }

    public BlobHolder convert(String converterName, BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        ConverterCheckResult check = this.isConverterAvailable(converterName);
        if (!check.isAvailable()) {
            throw new ConverterNotAvailable(converterName);
        }
        ConverterDescriptor desc = converterDescriptors.get(converterName);
        if (desc == null) {
            throw new ConversionException("Converter " + converterName + " can not be found");
        }
        String cacheKey = CacheKeyGenerator.computeKey(converterName, blobHolder, parameters);
        BlobHolder cachedResult = ConversionCacheHolder.getFromCache(cacheKey);
        if (cachedResult != null) {
            return cachedResult;
        }
        Converter converter = desc.getConverterInstance();
        BlobHolder result = converter.convert(blobHolder, parameters);
        if (config.isCacheEnabled()) {
            ConversionCacheHolder.addToCache(cacheKey, result);
        }
        return result;
    }

    public BlobHolder convertToMimeType(String destinationMimeType, BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String converterName;
        try {
            String srcMt = blobHolder.getBlob().getMimeType();
            converterName = translationHelper.getConverterName(srcMt, destinationMimeType);
        }
        catch (ClientException e) {
            throw new ConversionException("error while trying to determine converter name", (Exception)((Object)e));
        }
        if (converterName == null) {
            throw new ConversionException("unable to find converter for target mime type");
        }
        return this.convert(converterName, blobHolder, parameters);
    }

    public List<String> getConverterNames(String sourceMimeType, String destinationMimeType) {
        return translationHelper.getConverterNames(sourceMimeType, destinationMimeType);
    }

    public String getConverterName(String sourceMimeType, String destinationMimeType) {
        List<String> converterNames = this.getConverterNames(sourceMimeType, destinationMimeType);
        if (!converterNames.isEmpty()) {
            return converterNames.get(converterNames.size() - 1);
        }
        return null;
    }

    public ConverterCheckResult isConverterAvailable(String converterName) throws ConversionException {
        return this.isConverterAvailable(converterName, false);
    }

    public ConverterCheckResult isConverterAvailable(String converterName, boolean refresh) throws ConversionException {
        ConverterCheckResult result;
        if (!refresh && this.checkResultCache.containsKey(converterName)) {
            return this.checkResultCache.get(converterName);
        }
        ConverterDescriptor descriptor = converterDescriptors.get(converterName);
        if (descriptor == null) {
            throw new ConverterNotRegistered(converterName);
        }
        Converter converter = descriptor.getConverterInstance();
        if (converter instanceof ExternalConverter) {
            ExternalConverter exConverter = (ExternalConverter)converter;
            result = exConverter.isConverterAvailable();
        } else if (converter instanceof ChainedConverter) {
            ChainedConverter chainedConverter = (ChainedConverter)converter;
            result = new ConverterCheckResult();
            if (chainedConverter.isSubConvertersBased()) {
                String subConverterName;
                Iterator<String> i$ = chainedConverter.getSubConverters().iterator();
                while (i$.hasNext() && (result = this.isConverterAvailable(subConverterName = i$.next(), refresh)).isAvailable()) {
                }
            }
        } else {
            result = new ConverterCheckResult();
        }
        result.setSupportedInputMimeTypes(descriptor.getSourceMimeTypes());
        this.checkResultCache.put(converterName, result);
        return result;
    }

    public boolean isSourceMimeTypeSupported(String converterName, String sourceMimeType) {
        return ConversionServiceImpl.getConverterDescriptor(converterName).getSourceMimeTypes().contains(sourceMimeType);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(MimeTypeTranslationHelper.class)) {
            return adapter.cast(translationHelper);
        }
        return (T)super.getAdapter(adapter);
    }
}

