/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinOneDecorator
extends SolverDecorator<ISolver>
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] prevmodel;
    private boolean isSolutionOptimal;
    private int counter;
    private final IVecInt literals = new VecInt();
    private IConstr previousConstr;

    public MinOneDecorator(ISolver solver) {
        super(solver);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean result = this.isSatisfiable(assumps, true);
        if (result) {
            this.prevmodel = super.model();
            this.calculateObjectiveValue();
        } else {
            this.isSolutionOptimal = true;
        }
        return result;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        this.calculateObjectiveValue();
        return new Integer(this.counter);
    }

    private void calculateObjectiveValue() {
        this.counter = 0;
        int[] nArray = this.prevmodel;
        int n = this.prevmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (p > 0) {
                ++this.counter;
            }
            ++n2;
        }
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        if (this.literals.isEmpty()) {
            int i = 1;
            while (i <= this.nVars()) {
                this.literals.push(i);
                ++i;
            }
        }
        if (this.previousConstr != null) {
            super.removeConstr(this.previousConstr);
        }
        this.previousConstr = this.addAtMost(this.literals, this.counter - 1);
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public void reset() {
        this.literals.clear();
        this.previousConstr = null;
        super.reset();
    }

    @Override
    public Number getObjectiveValue() {
        return new Integer(this.counter);
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        try {
            this.addAtMost(this.literals, forcedValue.intValue());
        }
        catch (ContradictionException ce) {
            this.isSolutionOptimal = true;
            throw ce;
        }
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

