/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.select2;

import java.io.Serializable;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.api.ui.DirectoryUI;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIManager;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;

@Name(value="select2DirectoryActions")
@Scope(value=ScopeType.PAGE)
public class Select2DirectoryActionsBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected DirectoryUIManager directoryUIManager;
    protected String directoryName;
    protected DocumentModel newDirectoryEntry;

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public DocumentModel getCreationDirectoryEntry(String directoryName) throws ClientException {
        if (this.newDirectoryEntry == null || directoryName != null && !directoryName.equals(this.getDirectoryName())) {
            this.setDirectoryName(directoryName);
            DirectoryService dirService = DirectoryHelper.getDirectoryService();
            String schema = dirService.getDirectorySchema(directoryName);
            this.newDirectoryEntry = BaseSession.createEntryModel(null, (String)schema, null, null);
        }
        return this.newDirectoryEntry;
    }

    public String getCreationDirectoryEntryLayout(String directoryName) throws ClientException {
        DirectoryUI currentDirectoryInfo = this.directoryUIManager.getDirectoryInfo(directoryName);
        if (currentDirectoryInfo != null) {
            return currentDirectoryInfo.getLayout();
        }
        return null;
    }

    public void createDirectoryEntry() throws ClientException {
        try (Session dirSession = null;){
            DirectoryService dirService = DirectoryHelper.getDirectoryService();
            String dirName = this.getDirectoryName();
            String schema = dirService.getDirectorySchema(dirName);
            String idField = dirService.getDirectoryIdField(dirName);
            Object id = this.newDirectoryEntry.getProperty(schema, idField);
            dirSession = dirService.open(dirName);
            if (id instanceof String && dirSession.hasEntry((String)id)) {
                this.facesMessages.addToControl("suggestAddNewDirectoryEntry", StatusMessage.Severity.ERROR, this.messages.get("vocabulary.entry.identifier.already.exists"), new Object[0]);
                return;
            }
            dirSession.createEntry(this.newDirectoryEntry);
            this.reset();
            Events.instance().raiseEvent("directoryChanged", new Object[]{dirName});
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("vocabulary.entry.added"), new Object[0]);
        }
    }

    public void cancelCreateDirectoryEntry() throws ClientException {
        this.reset();
    }

    public void reset() {
        this.directoryName = null;
        this.newDirectoryEntry = null;
    }
}

