/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class NuxeoRepositories
extends DefaultComponent {
    protected static Map<String, NuxeoRepository> repositories;

    public void deactivate(ComponentContext context) throws Exception {
        NuxeoRepositories.clear();
    }

    public static void clear() {
        repositories = null;
    }

    public static NuxeoRepository getRepository(String repositoryId) {
        if (repositories == null) {
            NuxeoRepositories.initRepositories();
        }
        return repositories.get(repositoryId);
    }

    public static List<NuxeoRepository> getRepositories() {
        if (repositories == null) {
            NuxeoRepositories.initRepositories();
        }
        return new ArrayList<NuxeoRepository>(repositories.values());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void initRepositories() {
        repositories = Collections.synchronizedMap(new HashMap());
        try {
            RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
            for (String repositoryName : repositoryManager.getRepositoryNames()) {
                try {
                    CoreSession coreSession = CoreInstance.openCoreSession((String)repositoryName);
                    Throwable throwable = null;
                    try {
                        String rootFolderId = coreSession.getRootDocument().getId();
                        repositories.put(repositoryName, new NuxeoRepository(repositoryName, rootFolderId));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (coreSession == null) continue;
                        if (throwable != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        coreSession.close();
                    }
                }
                catch (ClientException e) {
                    throw new CmisRuntimeException(e.toString(), (Throwable)e);
                    return;
                }
            }
        }
        catch (CmisRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }
}

