/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.gwt;

import com.google.gwt.user.client.rpc.SerializableException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.remoting.gwt.GWTToSeamAdapter;
import org.jboss.seam.servlet.ContextualHttpServletRequest;
import org.jboss.seam.web.AbstractResource;

public abstract class GWTService
extends AbstractResource {
    protected static final LogProvider log = Logging.getLogProvider(GWTService.class);
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_ENCODING_GZIP = "gzip";
    private static final String CONTENT_TYPE_TEXT_PLAIN_UTF8 = "text/plain; charset=utf-8";
    private static final String GENERIC_FAILURE_MSG = "The call failed on the server; see server log for details";
    private static final HashMap TYPE_NAMES = new HashMap();
    private static final int UNCOMPRESSED_BYTE_SIZE_LIMIT = 256;
    private final ThreadLocal perThreadRequest = new ThreadLocal();
    private final ThreadLocal perThreadResponse = new ThreadLocal();

    public String getResourcePath() {
        return "/gwt";
    }

    protected abstract ServerSerializationStreamReader getStreamReader();

    protected abstract ServerSerializationStreamWriter getStreamWriter();

    protected abstract String createResponse(ServerSerializationStreamWriter var1, Class var2, Object var3, boolean var4);

    private static boolean acceptsGzipEncoding(HttpServletRequest request) {
        assert (request != null);
        String acceptEncoding = request.getHeader(ACCEPT_ENCODING);
        if (null == acceptEncoding) {
            return false;
        }
        return acceptEncoding.indexOf(CONTENT_ENCODING_GZIP) != -1;
    }

    private static int estimateByteSize(String buffer) {
        return buffer.length() * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getResource(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            this.perThreadRequest.set(request);
            this.perThreadResponse.set(response);
            new ContextualHttpServletRequest(request){

                public void process() throws Exception {
                    Throwable caught;
                    try {
                        String requestPayload = GWTService.this.readPayloadAsUtf8(request);
                        String responsePayload = GWTService.this.processCall(requestPayload);
                        GWTService.this.writeResponse(request, response, responsePayload);
                        return;
                    }
                    catch (IOException e) {
                        caught = e;
                    }
                    catch (ServletException e) {
                        caught = e;
                    }
                    catch (SerializationException e) {
                        caught = e;
                    }
                    catch (Throwable e) {
                        caught = e;
                    }
                    GWTService.this.respondWithFailure(response, caught);
                }

                protected void restoreConversationId() {
                }

                protected void handleConversationPropagation() {
                }
            }.run();
        }
        finally {
            this.perThreadRequest.remove();
            this.perThreadResponse.remove();
        }
    }

    public String processCall(String payload) throws SerializationException {
        Throwable caught;
        String responsePayload;
        block10: {
            this.onBeforeRequestDeserialized(payload);
            ServerSerializationStreamReader streamReader = this.getStreamReader();
            streamReader.prepareToRead(payload);
            String serviceIntfName = streamReader.readString();
            String methodName = streamReader.readString();
            int paramCount = streamReader.readInt();
            Class[] paramTypes = new Class[paramCount];
            for (int i = 0; i < paramTypes.length; ++i) {
                String paramClassName = streamReader.readString();
                try {
                    paramTypes[i] = this.getClassOrPrimitiveFromName(paramClassName);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new SerializationException("Unknown parameter " + i + " type '" + paramClassName + "'", (Throwable)e);
                }
            }
            Object[] args = new Object[paramCount];
            for (int i = 0; i < args.length; ++i) {
                args[i] = streamReader.deserializeValue(paramTypes[i]);
            }
            GWTToSeamAdapter adapter = GWTToSeamAdapter.instance();
            responsePayload = GENERIC_FAILURE_MSG;
            ServerSerializationStreamWriter streamWriter = this.getStreamWriter();
            caught = null;
            try {
                GWTToSeamAdapter.ReturnedObject returnedObject = adapter.callWebRemoteMethod(serviceIntfName, methodName, paramTypes, args);
                Class returnType = returnedObject.returnType;
                Object returnVal = returnedObject.returnedObject;
                responsePayload = this.createResponse(streamWriter, returnType, returnVal, false);
            }
            catch (IllegalArgumentException e) {
                caught = e;
            }
            catch (IllegalAccessException e) {
                caught = e;
            }
            catch (InvocationTargetException e) {
                caught = e;
                Throwable cause = e.getCause();
                if (cause == null) break block10;
                caught = cause;
                if (!(cause instanceof SerializableException)) break block10;
                Class<?> thrownClass = cause.getClass();
                responsePayload = this.createResponse(streamWriter, thrownClass, cause, true);
                caught = null;
            }
        }
        if (caught != null) {
            responsePayload = GENERIC_FAILURE_MSG;
            ServletContext servletContext = this.getServletContext();
            if (servletContext != null) {
                servletContext.log("Exception while dispatching incoming RPC call", caught);
            }
        }
        this.onAfterResponseSerialized(responsePayload);
        return responsePayload;
    }

    protected final HttpServletRequest getThreadLocalRequest() {
        return (HttpServletRequest)this.perThreadRequest.get();
    }

    protected final HttpServletResponse getThreadLocalResponse() {
        return (HttpServletResponse)this.perThreadResponse.get();
    }

    protected void onAfterResponseSerialized(String serializedResponse) {
    }

    protected void onBeforeRequestDeserialized(String serializedRequest) {
    }

    protected boolean shouldCompressResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) {
        return GWTService.estimateByteSize(responsePayload) > 256;
    }

    private Class getClassFromName(String name) throws ClassNotFoundException {
        return Class.forName(name, false, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private Class getClassOrPrimitiveFromName(String name) throws ClassNotFoundException {
        Object value = TYPE_NAMES.get(name);
        if (value != null) {
            return (Class)value;
        }
        return this.getClassFromName(name);
    }

    protected String[] getPackagePaths() {
        return new String[]{"com.google.gwt.user.client.rpc.core"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPayloadAsUtf8(HttpServletRequest request) throws IOException, ServletException {
        int contentLength = request.getContentLength();
        if (contentLength == -1) {
            throw new ServletException("Content-Length must be specified");
        }
        String contentType = request.getContentType();
        boolean contentTypeIsOkay = false;
        if (contentType != null && (contentType.startsWith("text/plain") || contentType.startsWith("text/x-gwt-rpc"))) {
            if (contentType.indexOf("charset=") == -1) {
                contentTypeIsOkay = true;
            } else if (contentType.indexOf("charset=utf-8") != -1) {
                contentTypeIsOkay = true;
            }
        }
        if (!contentTypeIsOkay) {
            throw new ServletException("Content-Type must be 'text/plain' or 'text/x-gwt-rpc' with 'charset=utf-8' (or unspecified charset)");
        }
        ServletInputStream in = request.getInputStream();
        try {
            byte[] payload = new byte[contentLength];
            int offset = 0;
            int len = contentLength;
            while (offset < contentLength) {
                int byteCount = in.read(payload, offset, len);
                if (byteCount == -1) {
                    throw new ServletException("Client did not send " + contentLength + " bytes as expected");
                }
                offset += byteCount;
                len -= byteCount;
            }
            String string = new String(payload, CHARSET_UTF8);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void respondWithFailure(HttpServletResponse response, Throwable caught) {
        ServletContext servletContext = this.getServletContext();
        servletContext.log("Exception while dispatching incoming RPC call", caught);
        try {
            response.setContentType("text/plain");
            response.setStatus(500);
            response.getWriter().write(GENERIC_FAILURE_MSG);
        }
        catch (IOException e) {
            servletContext.log("sendError() failed while sending the previous failure to the client", caught);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpServletRequest request, HttpServletResponse response, String responsePayload) throws IOException {
        byte[] reply = responsePayload.getBytes(CHARSET_UTF8);
        String contentType = CONTENT_TYPE_TEXT_PLAIN_UTF8;
        if (GWTService.acceptsGzipEncoding(request) && this.shouldCompressResponse(request, response, responsePayload)) {
            ByteArrayOutputStream output = null;
            DeflaterOutputStream gzipOutputStream = null;
            IOException caught = null;
            try {
                output = new ByteArrayOutputStream(reply.length);
                gzipOutputStream = new GZIPOutputStream(output);
                gzipOutputStream.write(reply);
                ((GZIPOutputStream)gzipOutputStream).finish();
                gzipOutputStream.flush();
                response.setHeader(CONTENT_ENCODING, CONTENT_ENCODING_GZIP);
                reply = output.toByteArray();
            }
            catch (UnsupportedEncodingException e) {
                caught = e;
            }
            catch (IOException e) {
                caught = e;
            }
            finally {
                if (null != gzipOutputStream) {
                    gzipOutputStream.close();
                }
                if (null != output) {
                    output.close();
                }
            }
            if (caught != null) {
                this.getServletContext().log("Unable to compress response", (Throwable)caught);
                response.sendError(500);
                return;
            }
        }
        response.setContentLength(reply.length);
        response.setContentType(contentType);
        response.setStatus(200);
        response.getOutputStream().write(reply);
    }

    static {
        TYPE_NAMES.put("Z", Boolean.TYPE);
        TYPE_NAMES.put("B", Byte.TYPE);
        TYPE_NAMES.put("C", Character.TYPE);
        TYPE_NAMES.put("D", Double.TYPE);
        TYPE_NAMES.put("F", Float.TYPE);
        TYPE_NAMES.put("I", Integer.TYPE);
        TYPE_NAMES.put("J", Long.TYPE);
        TYPE_NAMES.put("S", Short.TYPE);
    }
}

