/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http.proxy;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.proxy.ProxyPacResolver;
import org.nuxeo.connect.connector.http.proxy.SimpleStringCache;

public class RhinoProxyPacResolver
extends ProxyPacResolver {
    private static final Log log = LogFactory.getLog(RhinoProxyPacResolver.class);
    protected static final String PAC_FUNCTIONS_FILE = "proxy_pac_functions.js";
    protected static final String EXEC_PAC_FUNC = "FindProxyForURL(\"%s\", \"%s\");";
    protected SimpleStringCache fileCache = new SimpleStringCache(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] findPacProxies(String url) {
        Context ctx = ContextFactory.getGlobal().enterContext();
        try {
            ScriptableObject scope = ctx.initStandardObjects();
            ScriptableObject.putProperty((Scriptable)scope, (String)"dnsResolve", (Object)((Object)new DnsResolveFunction()));
            ScriptableObject.putProperty((Scriptable)scope, (String)"myIpAddress", (Object)((Object)new MyIpAddressFunction()));
            ctx.evaluateReader((Scriptable)scope, this.getFileReader(PAC_FUNCTIONS_FILE), PAC_FUNCTIONS_FILE, 0, null);
            ctx.evaluateReader((Scriptable)scope, this.getRemotePacBodyReader(), "remote pac", 0, null);
            String[] stringArray = ((String)ctx.evaluateString((Scriptable)scope, String.format(EXEC_PAC_FUNC, url, RhinoProxyPacResolver.getHost(url)), "function call", 0, null)).split(";");
            return stringArray;
        }
        catch (IOException | RhinoException io) {
            log.warn((Object)io, io);
        }
        finally {
            Context.exit();
        }
        return null;
    }

    protected Reader getFileReader(String filename) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(filename);
        if (resource == null) {
            throw new IOException("Unable to find file: " + filename);
        }
        return new InputStreamReader(resource.openStream());
    }

    protected Reader getRemotePacBodyReader() throws IOException {
        if (NuxeoConnectClient.isTestModeSet()) {
            return this.getFileReader(System.getProperty("nuxeo.test.pac.fake.remote.file"));
        }
        if (this.fileCache.getValue() == null) {
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(ConnectUrlConfig.getProxyPacUrl());
            int status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                this.fileCache.saveValue(method.getResponseBodyAsString());
            } else {
                throw new IOException("Unable to get pac file");
            }
        }
        return new StringReader(this.fileCache.getValue());
    }

    protected class MyIpAddressFunction
    extends BaseFunction {
        private static final long serialVersionUID = 1L;

        protected MyIpAddressFunction() {
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objects) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return "127.0.0.1";
            }
        }
    }

    protected class DnsResolveFunction
    extends BaseFunction {
        private static final long serialVersionUID = 1L;

        protected DnsResolveFunction() {
        }

        public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objects) {
            try {
                if (objects.length > 0) {
                    return InetAddress.getByName((String)objects[0]).getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                log.debug((Object)e, (Throwable)e);
            }
            return null;
        }
    }
}

