/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.engine.main.JoinClassifier;
import com.hp.hpl.jena.sparql.engine.main.LeftJoinClassifier;
import com.hp.hpl.jena.sparql.util.Context;

public class TransformJoinStrategy
extends TransformCopy {
    private final Context context;

    public TransformJoinStrategy(Context context) {
        this.context = context;
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        boolean canDoLinear = JoinClassifier.isLinear(opJoin);
        if (canDoLinear) {
            if (right instanceof OpTable) {
                Op tmp = left;
                left = right;
                right = tmp;
            }
            return OpSequence.create(left, right);
        }
        return super.transform(opJoin, left, right);
    }

    public Op transform(OpLeftJoin opLeftJoin, Op opLeft, Op opRight) {
        boolean canDoLinear = LeftJoinClassifier.isLinear(opLeftJoin);
        if (canDoLinear) {
            if (opLeftJoin.getExprs() != null) {
                opRight = OpFilter.filter(opLeftJoin.getExprs(), opRight);
            }
            return new OpConditional(opLeft, opRight);
        }
        return super.transform(opLeftJoin, opLeft, opRight);
    }
}

