/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.graph.NodeTransform;

public class UnrenameVars
implements NodeTransform {
    private final String varPrefix;
    private final boolean repeatedly;

    public UnrenameVars(String varPrefix, boolean repeatedly) {
        this.varPrefix = varPrefix;
        this.repeatedly = repeatedly;
    }

    public Node convert(Node node) {
        if (!Var.isVar(node)) {
            return node;
        }
        Var var = (Var)node;
        String varName = var.getName();
        if (this.repeatedly) {
            while (varName.startsWith(this.varPrefix)) {
                varName = varName.substring(this.varPrefix.length());
            }
        } else if (varName.startsWith(this.varPrefix)) {
            varName = varName.substring(this.varPrefix.length());
        }
        if (varName == var.getName()) {
            return node;
        }
        return Var.alloc(varName);
    }
}

