/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;

public class AggCountVar
extends AggregatorBase {
    private Expr expr;

    public AggCountVar(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy(Expr expr) {
        return new AggCountVar(expr);
    }

    public String toString() {
        return "count(" + this.expr + ")";
    }

    public String toPrefixString() {
        return "(count " + this.expr + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccCountVar(this.expr);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public int hashCode() {
        return 0x174 ^ this.expr.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AggCountVar)) {
            return false;
        }
        AggCountVar agg = (AggCountVar)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    private static class AccCountVar
    extends AccumulatorExpr {
        private long count = 0L;

        public AccCountVar(Expr expr) {
            super(expr);
        }

        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

