/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.util.FileUtils;
import org.openjena.riot.RiotException;
import org.openjena.riot.WebContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Lang {
    RDFXML("RDF/XML", true, "RDF/XML", "RDF/XML-ABBREV"),
    NTRIPLES("N-Triples", true, "N-TRIPLES", "N-TRIPLE"),
    N3("N3", true, new String[0]),
    TURTLE("Turtle", true, "TTL"),
    NQUADS("N-Quads", false, "NQUADS"),
    TRIG("TriG", false, new String[0]);

    private final String name;
    private final boolean isTriples;
    private final String[] altNames;
    private static final String[] extRDFXML;
    private static final String[] extNTriples;
    private static final String[] extNTurtle;
    private static final String[] extN3;
    private static final String[] extNQuads;
    private static final String[] extTrig;

    private Lang(String name, boolean isTriples, String ... altNames) {
        this.name = name;
        this.isTriples = isTriples;
        this.altNames = altNames;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTriples() {
        return this.isTriples;
    }

    public boolean isQuads() {
        return !this.isTriples;
    }

    public String getContentType() {
        return WebContent.mapLangToContentType(this);
    }

    public String toString() {
        return "lang:" + this.name;
    }

    public static Lang get(String name) {
        Lang lang = Lang.get(name, null);
        if (lang == null) {
            throw new RiotException("No such language: " + name);
        }
        return lang;
    }

    public static Lang get(String name, Lang dftLang) {
        if (Lang.matchesLangName(name, RDFXML)) {
            return RDFXML;
        }
        if (Lang.matchesLangName(name, NTRIPLES)) {
            return NTRIPLES;
        }
        if (Lang.matchesLangName(name, TURTLE)) {
            return TURTLE;
        }
        if (Lang.matchesLangName(name, NQUADS)) {
            return NQUADS;
        }
        if (Lang.matchesLangName(name, TRIG)) {
            return TRIG;
        }
        return dftLang;
    }

    private static boolean matchesLangName(String name, Lang lang) {
        if (name.equalsIgnoreCase(lang.name)) {
            return true;
        }
        if (lang.altNames != null) {
            for (String x : lang.altNames) {
                if (!x.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static Lang guess(String resourceIRI, Lang dftLang) {
        Lang lang = Lang.guess(resourceIRI);
        if (lang != null) {
            return lang;
        }
        return dftLang;
    }

    public static Lang guess(String resourceIRI) {
        if (resourceIRI == null) {
            return null;
        }
        String ext = FileUtils.getFilenameExt((String)resourceIRI).toLowerCase();
        if (ext != null && ext.equals("gz")) {
            resourceIRI = resourceIRI.substring(0, resourceIRI.length() - ".gz".length());
            ext = FileUtils.getFilenameExt((String)resourceIRI).toLowerCase();
        }
        if (Lang.isOneOf(ext, extRDFXML)) {
            return RDFXML;
        }
        if (Lang.isOneOf(ext, extNTriples)) {
            return NTRIPLES;
        }
        if (Lang.isOneOf(ext, extNTurtle)) {
            return TURTLE;
        }
        if (Lang.isOneOf(ext, extN3)) {
            return N3;
        }
        if (Lang.isOneOf(ext, extNQuads)) {
            return NQUADS;
        }
        if (Lang.isOneOf(ext, extTrig)) {
            return TRIG;
        }
        return null;
    }

    private static boolean isOneOf(String ext, String[] names) {
        for (String x : names) {
            if (!ext.equals(x)) continue;
            return true;
        }
        return false;
    }

    static {
        extRDFXML = new String[]{"rdf", "owl", "xml"};
        extNTriples = new String[]{"nt"};
        extNTurtle = new String[]{"ttl"};
        extN3 = new String[]{"n3"};
        extNQuads = new String[]{"nq"};
        extTrig = new String[]{"trig"};
    }
}

