/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme;

import java.io.InputStream;
import java.net.URL;

public class ResourceResolver {
    private static final ResourceResolver DEFAULT = new ResourceResolver();
    private static ThreadLocal<ResourceResolver> instance = new ThreadLocal<ResourceResolver>(){

        @Override
        protected ResourceResolver initialValue() {
            return DEFAULT;
        }
    };

    public static ResourceResolver getInstance() {
        return instance.get();
    }

    public static void setInstance(ResourceResolver resolver) {
        if (resolver == null) {
            instance.set(DEFAULT);
        } else {
            instance.set(resolver);
        }
    }

    public URL getResource(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(path);
        if (url == null) {
            url = cl.getResource("nuxeo.war/" + path);
        }
        return url;
    }

    public InputStream getResourceAsStream(String path) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(path);
        if (is == null) {
            is = cl.getResourceAsStream("nuxeo.war/" + path);
        }
        return is;
    }
}

