/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Registrable;
import org.nuxeo.theme.types.Type;
import org.nuxeo.theme.types.TypeFamily;

public final class TypeRegistry
implements Registrable {
    private static final Log log = LogFactory.getLog(TypeRegistry.class);
    private final Map<String, Type> registry = new ConcurrentHashMap<String, Type>();
    private final Map<TypeFamily, List<String>> typeNames = new ConcurrentHashMap<TypeFamily, List<String>>();

    public synchronized void register(Type type) {
        List<String> typeNamesByFamily;
        String typeName = type.getTypeName();
        TypeFamily typeFamily = type.getTypeFamily();
        String key = TypeRegistry.computeKey(typeFamily, typeName);
        if (this.registry.containsKey(key)) {
            log.debug((Object)("Overriding theme " + (Object)((Object)typeFamily) + ": " + typeName));
        }
        this.registry.put(key, type);
        if (!this.typeNames.containsKey((Object)typeFamily)) {
            this.typeNames.put(typeFamily, new ArrayList());
        }
        if (!(typeNamesByFamily = this.typeNames.get((Object)typeFamily)).contains(typeName)) {
            typeNamesByFamily.add(typeName);
        }
        log.debug((Object)("Registered theme " + (Object)((Object)typeFamily) + ": " + typeName));
    }

    public synchronized void unregister(Type type) {
        String typeName = type.getTypeName();
        TypeFamily typeFamily = type.getTypeFamily();
        String key = TypeRegistry.computeKey(typeFamily, typeName);
        this.registry.remove(key);
        if (this.typeNames.containsKey((Object)typeFamily)) {
            this.typeNames.get((Object)typeFamily).remove(typeName);
        }
        log.debug((Object)("Unregistered theme " + (Object)((Object)typeFamily) + ": " + typeName));
    }

    public Type lookup(TypeFamily typeFamily, String name) {
        String key = TypeRegistry.computeKey(typeFamily, name);
        return this.registry.get(key);
    }

    public Type lookup(TypeFamily typeFamily, String ... names) {
        for (String name : names) {
            String key;
            Type type;
            if (name == null || (type = this.registry.get(key = TypeRegistry.computeKey(typeFamily, name))) == null) continue;
            return type;
        }
        return null;
    }

    public List<String> getTypeNames(TypeFamily typeFamily) {
        if (!this.typeNames.containsKey((Object)typeFamily)) {
            return new ArrayList<String>();
        }
        return this.typeNames.get((Object)typeFamily);
    }

    public List<Type> getTypes(TypeFamily typeFamily) {
        ArrayList<Type> types = new ArrayList<Type>();
        if (this.typeNames.containsKey((Object)typeFamily)) {
            for (String typeName : this.typeNames.get((Object)typeFamily)) {
                types.add(this.lookup(typeFamily, typeName));
            }
        }
        return types;
    }

    private static String computeKey(TypeFamily family, String name) {
        return String.format("%s/%s", new Object[]{family, name});
    }

    @Override
    public synchronized void clear() {
        this.registry.clear();
        this.typeNames.clear();
    }
}

