/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.types.TypeManager;

public class CSVZipImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    private static final String MARKER = "meta-data.csv";
    private static final Log log = LogFactory.getLog(CSVZipImporter.class);

    public static ZipFile getArchiveFileIfValid(File file) throws IOException {
        ZipFile zip;
        try {
            zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug((Object)"file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug((Object)"can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = zip.getEntry(MARKER);
        if (marker == null) {
            zip.close();
            return null;
        }
        return zip;
    }

    @Override
    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String filename, TypeManager typeService) throws ClientException, IOException {
        File tmp = File.createTempFile("zipcsv-importer", null);
        content.transferTo(tmp);
        ZipFile zip = CSVZipImporter.getArchiveFileIfValid(tmp);
        if (zip == null) {
            tmp.delete();
            return null;
        }
        DocumentModel container = documentManager.getDocument((DocumentRef)new PathRef(path));
        ZipEntry index = zip.getEntry(MARKER);
        InputStream indexStream = zip.getInputStream(index);
        InputStreamReader reader = new InputStreamReader(indexStream);
        CSVReader csvReader = new CSVReader((Reader)reader);
        List lines = csvReader.readAll();
        String[] header = (String[])lines.get(0);
        for (int idx = 1; idx < lines.size(); ++idx) {
            String targetPath;
            String type = null;
            String id = null;
            HashMap<String, String> stringValues = new HashMap<String, String>();
            for (int col = 0; col < header.length; ++col) {
                String headerValue = header[col];
                String lineValue = ((String[])lines.get(idx))[col];
                if ("type".equalsIgnoreCase(headerValue)) {
                    type = lineValue;
                    continue;
                }
                if ("id".equalsIgnoreCase(headerValue)) {
                    id = lineValue;
                    continue;
                }
                stringValues.put(headerValue, lineValue);
            }
            boolean updateDoc = false;
            DocumentModel targetDoc = null;
            if (id != null && documentManager.exists((DocumentRef)new PathRef(targetPath = new Path(path).append(id).toString()))) {
                targetDoc = documentManager.getDocument((DocumentRef)new PathRef(targetPath));
                updateDoc = true;
            }
            if (targetDoc == null) {
                if (type == null) {
                    log.error((Object)"Can not create doc without a type, skipping line");
                    continue;
                }
                if (id == null) {
                    id = IdUtils.generateStringId();
                }
                targetDoc = documentManager.createDocumentModel(path, id, type);
            }
            DocumentType docType = targetDoc.getDocumentType();
            for (String fname : stringValues.keySet()) {
                Serializable fieldValue;
                String stringValue = (String)stringValues.get(fname);
                Field field = null;
                boolean usePrefix = false;
                String schemaName = null;
                String fieldName = null;
                if (fname.contains(":")) {
                    if (docType.hasField(fname)) {
                        field = docType.getField(fname);
                        usePrefix = true;
                    }
                } else if (fname.contains(".")) {
                    String[] parts = fname.split("\\.");
                    schemaName = parts[0];
                    fieldName = parts[1];
                    if (docType.hasSchema(schemaName)) {
                        field = docType.getField(fieldName);
                        usePrefix = false;
                    }
                } else if (docType.hasField(fname)) {
                    field = docType.getField(fname);
                    usePrefix = false;
                    schemaName = field.getDeclaringType().getSchemaName();
                }
                if (field == null || (fieldValue = this.getFieldValue(field, stringValue, zip)) == null) continue;
                if (usePrefix) {
                    targetDoc.setPropertyValue(fname, fieldValue);
                    continue;
                }
                targetDoc.setProperty(schemaName, fieldName, (Object)fieldValue);
            }
            if (updateDoc) {
                documentManager.saveDocument(targetDoc);
                continue;
            }
            documentManager.createDocument(targetDoc);
        }
        tmp.delete();
        return container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Serializable getFieldValue(Field field, String stringValue, ZipFile zip) throws IOException {
        String fieldValue = null;
        Type type = field.getType();
        if (!type.isSimpleType()) {
            if (!type.isComplexType()) return fieldValue;
            if (!"content".equals(field.getName().getLocalName())) return fieldValue;
            ZipEntry blobIndex = zip.getEntry(stringValue);
            if (blobIndex == null) return fieldValue;
            InputStream blobStream = zip.getInputStream(blobIndex);
            InputStreamBlob blob = new InputStreamBlob(blobStream);
            blob.setFilename(stringValue);
            return (Serializable)blob;
        }
        if (type instanceof SimpleTypeImpl) {
            type = type.getSuperType();
        }
        if (type instanceof StringType) {
            return stringValue;
        }
        if (type instanceof IntegerType) {
            return Integer.valueOf(Integer.parseInt(stringValue));
        }
        if (type instanceof LongType) {
            return Long.valueOf(Long.parseLong(stringValue));
        }
        if (!(type instanceof DateType)) {
            log.warn((Object)String.format("Unsupported field type '%s'", type));
            return null;
        }
        try {
            Date date;
            if (stringValue.length() == 10) {
                date = new SimpleDateFormat("dd/MM/yyyy").parse(stringValue);
                return date;
            } else {
                if (stringValue.length() != 8) {
                    log.warn((Object)("Unknown date format :" + stringValue));
                    return null;
                }
                date = new SimpleDateFormat("dd/MM/yy").parse(stringValue);
            }
            return date;
        }
        catch (ParseException e) {
            log.error((Object)"Error during date parsing", (Throwable)e);
            return fieldValue;
        }
    }
}

