/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.ElementBase;
import org.ajax4jsf.renderkit.compiler.TemplateContext;

public class ChildrensElement
extends ElementBase {
    public static final String CURRENT_CHILD = "child_to_render";
    private String iteratorName;

    public String getIteratorName() {
        return this.iteratorName;
    }

    public void setIteratorName(String iteratorVar) {
        this.iteratorName = iteratorVar;
    }

    public void encode(TemplateContext context) throws IOException {
        UIComponent stored = (UIComponent)context.getParameter(CURRENT_CHILD);
        IteratorWrapper iter = new IteratorWrapper(Collections.EMPTY_LIST.iterator());
        Object value = this.getValue(context);
        if (value != null) {
            if (value instanceof UIComponent) {
                UIComponent comp = (UIComponent)value;
                iter = new IteratorWrapper(comp.getChildren().iterator());
            } else if (value instanceof Collection) {
                iter = new IteratorWrapper(((Collection)value).iterator());
            } else if (value instanceof String) {
                String componentId = (String)value;
                UIComponent comp = context.getComponent().findComponent(componentId);
                if (null != comp) {
                    iter = new IteratorWrapper(comp.getChildren().iterator());
                }
            } else if (value instanceof Iterator) {
                iter = new IteratorWrapper((Iterator)value);
            }
        } else {
            iter = new IteratorWrapper(context.getComponent().getChildren().iterator());
        }
        if (this.iteratorName != null) {
            context.putParameter(this.iteratorName, iter);
        }
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (!child.isRendered()) continue;
            if (this.getChildren().size() > 0) {
                context.putParameter(CURRENT_CHILD, child);
                super.encode(context);
                continue;
            }
            context.getRenderer().renderChild(context.getFacesContext(), child);
        }
        if (this.iteratorName != null) {
            context.removeParameter(this.iteratorName);
        }
        if (null != stored) {
            context.putParameter(CURRENT_CHILD, stored);
        } else {
            context.removeParameter(CURRENT_CHILD);
        }
    }

    public void encode(TemplateContext context, String breakPoint) throws IOException {
        throw new FacesException(Messages.getMessage((String)"BREAKPOINTS_UNSUPPORTED_ERROR_2"));
    }

    public String getTag() {
        return "u:insertChildren";
    }

    public class IteratorWrapper
    implements Iterator {
        private Iterator iterator;
        private int index = -1;

        public IteratorWrapper(Iterator iterator) {
            this.iterator = iterator;
        }

        public Iterator getIterator() {
            return this.iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            ++this.index;
            return o;
        }

        public void remove() {
            this.iterator.remove();
        }

        public boolean isLast() {
            return !this.iterator.hasNext();
        }

        public int getIndex() {
            return this.index;
        }
    }
}

