/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl.expressive;

import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.el.Expression;
import org.richfaces.model.Ordering;
import org.richfaces.model.SortField2;
import org.richfaces.model.impl.expressive.JavaBeanWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrappedBeanComparator2
implements Comparator<Object> {
    private static final Comparator<String> defaultStringComparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    };
    private final List<SortField2> sortFields;
    private Locale currentLocale;
    private Comparator<? super String> stringComparator;

    public WrappedBeanComparator2(List<SortField2> sortFields) {
        this(sortFields, null);
    }

    public WrappedBeanComparator2(List<SortField2> sortFields, Locale locale) {
        this.sortFields = sortFields;
        this.currentLocale = locale;
    }

    private Comparator<? super String> createStringComparator() {
        Collator comparator = null;
        comparator = this.currentLocale != null ? Collator.getInstance(this.currentLocale) : defaultStringComparator;
        return comparator;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare((JavaBeanWrapper)o1, (JavaBeanWrapper)o2);
    }

    @Override
    private int compare(JavaBeanWrapper w1, JavaBeanWrapper w2) {
        int result = 0;
        Iterator<SortField2> iterator = this.sortFields.iterator();
        while (iterator.hasNext() && result == 0) {
            Object p2;
            SortField2 field = iterator.next();
            Expression expression = field.getExpression();
            String prop = expression.getExpressionString();
            Ordering ordering = field.getOrdering();
            if (ordering == null) continue;
            Object p1 = w1.getProperty(prop);
            if (p1 == (p2 = w2.getProperty(prop)) && p1 instanceof Comparator) {
                result = ((Comparator)p1).compare(w1.getWrappedObject(), w2.getWrappedObject());
            } else if (p1 instanceof String && p2 instanceof String) {
                if (this.stringComparator == null) {
                    this.stringComparator = this.createStringComparator();
                }
                result = this.stringComparator.compare(((String)p1).trim(), ((String)p2).trim());
            } else if (p1 instanceof Comparable && p2 instanceof Comparable) {
                result = ((Comparable)p1).compareTo(p2);
            } else if (p1 == null && p2 != null) {
                result = 1;
            } else if (p2 == null && p1 != null) {
                result = -1;
            }
            if (!ordering.equals((Object)Ordering.DESCENDING)) continue;
            result = -result;
        }
        return result;
    }
}

