/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.ComparatorRegistry;
import org.apache.directory.server.schema.registries.DITContentRuleRegistry;
import org.apache.directory.server.schema.registries.DITStructureRuleRegistry;
import org.apache.directory.server.schema.registries.DefaultAttributeTypeRegistry;
import org.apache.directory.server.schema.registries.DefaultComparatorRegistry;
import org.apache.directory.server.schema.registries.DefaultDitContentRuleRegistry;
import org.apache.directory.server.schema.registries.DefaultDitStructureRuleRegistry;
import org.apache.directory.server.schema.registries.DefaultMatchingRuleRegistry;
import org.apache.directory.server.schema.registries.DefaultMatchingRuleUseRegistry;
import org.apache.directory.server.schema.registries.DefaultNameFormRegistry;
import org.apache.directory.server.schema.registries.DefaultNormalizerRegistry;
import org.apache.directory.server.schema.registries.DefaultObjectClassRegistry;
import org.apache.directory.server.schema.registries.DefaultSyntaxCheckerRegistry;
import org.apache.directory.server.schema.registries.DefaultSyntaxRegistry;
import org.apache.directory.server.schema.registries.MatchingRuleRegistry;
import org.apache.directory.server.schema.registries.MatchingRuleUseRegistry;
import org.apache.directory.server.schema.registries.NameFormRegistry;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.server.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaLoader;
import org.apache.directory.server.schema.registries.SchemaLoaderListener;
import org.apache.directory.server.schema.registries.SchemaObjectRegistry;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRegistries
implements Registries {
    private DefaultAttributeTypeRegistry attributeTypeRegistry;
    private DefaultComparatorRegistry comparatorRegistry;
    private DefaultDitContentRuleRegistry ditContentRuleRegistry;
    private DefaultDitStructureRuleRegistry ditStructureRuleRegistry;
    private DefaultMatchingRuleRegistry matchingRuleRegistry;
    private DefaultMatchingRuleUseRegistry matchingRuleUseRegistry;
    private DefaultNameFormRegistry nameFormRegistry;
    private DefaultNormalizerRegistry normalizerRegistry;
    private DefaultObjectClassRegistry objectClassRegistry;
    private OidRegistry oidRegistry;
    private DefaultSyntaxCheckerRegistry syntaxCheckerRegistry;
    private DefaultSyntaxRegistry syntaxRegistry;
    private Map<String, Schema> loadedByName = new HashMap<String, Schema>();
    private final SchemaLoader schemaLoader;
    private final String name;

    public DefaultRegistries(String name, SchemaLoader schemaLoader, OidRegistry registry) {
        this.name = name;
        this.schemaLoader = schemaLoader;
        this.schemaLoader.setListener(new SchemaLoaderListener(){

            public void schemaLoaded(Schema schema) {
                DefaultRegistries.this.loadedByName.put(schema.getSchemaName(), schema);
            }
        });
        this.oidRegistry = registry;
        this.normalizerRegistry = new DefaultNormalizerRegistry();
        this.comparatorRegistry = new DefaultComparatorRegistry();
        this.syntaxCheckerRegistry = new DefaultSyntaxCheckerRegistry();
        this.syntaxRegistry = new DefaultSyntaxRegistry(this.oidRegistry);
        this.matchingRuleRegistry = new DefaultMatchingRuleRegistry(this.oidRegistry);
        this.attributeTypeRegistry = new DefaultAttributeTypeRegistry(this.oidRegistry);
        this.objectClassRegistry = new DefaultObjectClassRegistry(this.oidRegistry);
        this.ditContentRuleRegistry = new DefaultDitContentRuleRegistry(this.oidRegistry);
        this.ditStructureRuleRegistry = new DefaultDitStructureRuleRegistry(this.oidRegistry);
        this.matchingRuleUseRegistry = new DefaultMatchingRuleUseRegistry();
        this.nameFormRegistry = new DefaultNameFormRegistry(this.oidRegistry);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AttributeTypeRegistry getAttributeTypeRegistry() {
        return this.attributeTypeRegistry;
    }

    @Override
    public ComparatorRegistry getComparatorRegistry() {
        return this.comparatorRegistry;
    }

    @Override
    public DITContentRuleRegistry getDitContentRuleRegistry() {
        return this.ditContentRuleRegistry;
    }

    @Override
    public DITStructureRuleRegistry getDitStructureRuleRegistry() {
        return this.ditStructureRuleRegistry;
    }

    @Override
    public MatchingRuleRegistry getMatchingRuleRegistry() {
        return this.matchingRuleRegistry;
    }

    @Override
    public MatchingRuleUseRegistry getMatchingRuleUseRegistry() {
        return this.matchingRuleUseRegistry;
    }

    @Override
    public NameFormRegistry getNameFormRegistry() {
        return this.nameFormRegistry;
    }

    @Override
    public NormalizerRegistry getNormalizerRegistry() {
        return this.normalizerRegistry;
    }

    @Override
    public ObjectClassRegistry getObjectClassRegistry() {
        return this.objectClassRegistry;
    }

    @Override
    public OidRegistry getOidRegistry() {
        return this.oidRegistry;
    }

    @Override
    public SyntaxCheckerRegistry getSyntaxCheckerRegistry() {
        return this.syntaxCheckerRegistry;
    }

    @Override
    public SyntaxRegistry getSyntaxRegistry() {
        return this.syntaxRegistry;
    }

    public List checkRefInteg() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Iterator<MatchingRule> list = this.objectClassRegistry.iterator();
        while (list.hasNext()) {
            ObjectClass oc = list.next();
            this.resolve(oc, errors);
        }
        list = this.attributeTypeRegistry.list();
        while (list.hasNext()) {
            AttributeType at = (AttributeType)list.next();
            this.resolve(at, errors);
        }
        list = this.matchingRuleRegistry.iterator();
        while (list.hasNext()) {
            MatchingRule mr = list.next();
            this.resolve(mr, errors);
        }
        list = this.syntaxRegistry.iterator();
        while (list.hasNext()) {
            Syntax syntax = (Syntax)list.next();
            this.resolve(syntax, errors);
        }
        return errors;
    }

    private boolean resolve(Syntax syntax, List<Throwable> errors) {
        if (syntax == null) {
            return true;
        }
        try {
            syntax.getSyntaxChecker();
            return true;
        }
        catch (NamingException e) {
            errors.add(e);
            return false;
        }
    }

    private boolean resolve(MatchingRule mr, List<Throwable> errors) {
        String schema;
        boolean isSuccess = true;
        if (mr == null) {
            return true;
        }
        try {
            if (mr.getComparator() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null comparator"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            if (mr.getNormalizer() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null normalizer"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(mr.getSyntax(), errors);
            if (mr.getSyntax() == null) {
                schema = this.matchingRuleRegistry.getSchemaName(mr.getOid());
                errors.add(new NullPointerException("matchingRule " + mr.getName() + " in schema " + schema + " with OID " + mr.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean resolve(AttributeType at, List<Throwable> errors) {
        boolean isSuccess = true;
        boolean hasMatchingRule = false;
        if (at == null) {
            return true;
        }
        try {
            isSuccess &= this.resolve(at.getSuperior(), errors);
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getEquality(), errors);
            if (at.getEquality() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getOrdering(), errors);
            if (at.getOrdering() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSubstr(), errors);
            if (at.getSubstr() != null) {
                hasMatchingRule |= true;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        try {
            isSuccess &= this.resolve(at.getSyntax(), errors);
            if (at.getSyntax() == null) {
                String schema = this.attributeTypeRegistry.getSchemaName(at.getOid());
                errors.add(new NullPointerException("attributeType " + at.getName() + " in schema " + schema + " with OID " + at.getOid() + " has a null Syntax"));
                isSuccess = false;
            }
        }
        catch (NamingException e) {
            errors.add(e);
            isSuccess = false;
        }
        return isSuccess;
    }

    private boolean resolve(ObjectClass oc, List<Throwable> errors) {
        boolean isSuccess = true;
        if (oc == null) {
            return true;
        }
        ObjectClass[] superiors = new ObjectClass[]{};
        try {
            superiors = oc.getSuperClasses();
        }
        catch (NamingException e) {
            superiors = new ObjectClass[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < superiors.length; ++ii) {
            isSuccess &= this.resolve(superiors[ii], errors);
        }
        AttributeType[] mayList = new AttributeType[]{};
        try {
            mayList = oc.getMayList();
        }
        catch (NamingException e) {
            mayList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < mayList.length; ++ii) {
            isSuccess &= this.resolve(mayList[ii], errors);
        }
        AttributeType[] mustList = new AttributeType[]{};
        try {
            mustList = oc.getMustList();
        }
        catch (NamingException e) {
            mustList = new AttributeType[]{};
            isSuccess = false;
            errors.add(e);
        }
        for (int ii = 0; ii < mustList.length; ++ii) {
            isSuccess &= this.resolve(mustList[ii], errors);
        }
        return isSuccess;
    }

    @Override
    public Map<String, Schema> getLoadedSchemas() {
        return new HashMap<String, Schema>(this.loadedByName);
    }

    @Override
    public void load(String schemaName) throws NamingException {
        this.load(schemaName, new Properties());
    }

    @Override
    public void load(String schemaName, Properties schemaProperties) throws NamingException {
        Schema schema = this.schemaLoader.getSchema(schemaName, schemaProperties);
        if (schema.isDisabled()) {
            throw new NamingException("Disabled schemas cannot be loaded into registries.");
        }
        this.loadedByName.put(schema.getSchemaName(), schema);
        this.schemaLoader.load(schema, this, false);
    }

    @Override
    public void unload(String schemaName) throws NamingException {
        this.disableSchema(this.ditStructureRuleRegistry, schemaName);
        this.disableSchema(this.ditContentRuleRegistry, schemaName);
        this.disableSchema(this.matchingRuleUseRegistry, schemaName);
        this.disableSchema(this.nameFormRegistry, schemaName);
        this.disableSchema(this.objectClassRegistry, schemaName);
        this.disableSchema(this.attributeTypeRegistry, schemaName);
        this.disableSchema(this.matchingRuleRegistry, schemaName);
        this.disableSchema(this.syntaxRegistry, schemaName);
        this.normalizerRegistry.unregisterSchemaElements(schemaName);
        this.comparatorRegistry.unregisterSchemaElements(schemaName);
        this.syntaxCheckerRegistry.unregisterSchemaElements(schemaName);
        this.loadedByName.remove(schemaName);
    }

    private void disableSchema(SchemaObjectRegistry registry, String schemaName) throws NamingException {
        Iterator<? extends SchemaObject> objects = registry.iterator();
        ArrayList<String> unregistered = new ArrayList<String>();
        while (objects.hasNext()) {
            SchemaObject obj = objects.next();
            if (!obj.getSchema().equalsIgnoreCase(schemaName)) continue;
            unregistered.add(obj.getOid());
        }
        for (String oid : unregistered) {
            registry.unregister(oid);
        }
    }

    @Override
    public SchemaLoader setSchemaLoader() {
        return this.schemaLoader;
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.loadedByName.get(schemaName);
    }

    @Override
    public void addToLoadedSet(Schema schema) {
        this.loadedByName.put(schema.getSchemaName(), schema);
    }

    @Override
    public void removeFromLoadedSet(String schemaName) {
        this.loadedByName.remove(schemaName);
    }
}

