/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.impl.AuditEventFirer;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteStepsContainerImpl;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;

public class DocumentRouteImpl
extends DocumentRouteStepsContainerImpl
implements DocumentRoute {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentRouteImpl.class);

    @Override
    public void setDone(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDone, session, false);
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterRouteFinish.name());
        for (String attachDocumentID : this.getAttachedDocuments()) {
            try {
                DocumentModel doc = session.getDocument((DocumentRef)new IdRef(attachDocumentID));
                AuditEventFirer.fireEvent(session, this, null, "auditLogRoute", doc);
            }
            catch (ClientException e) {
                log.error((Object)String.format("Unable to fetch document with id '%s': %s", attachDocumentID, e.getMessage()));
                log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public DocumentRouteImpl(DocumentModel doc, ElementRunner runner) {
        super(doc, runner);
    }

    @Override
    public boolean canUndoStep(CoreSession session) {
        return false;
    }
}

