/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNodeImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphVariablesUtil;
import org.nuxeo.runtime.api.Framework;

public class GraphRouteImpl
extends DocumentRouteImpl
implements GraphRoute {
    private static final long serialVersionUID = 1L;
    protected List<GraphNode> nodes;
    protected Map<String, GraphNode> nodesById;

    public GraphRouteImpl(DocumentModel doc) {
        super(doc, new GraphRunner());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getName()).toString();
    }

    @Override
    public Collection<GraphNode> getNodes() {
        if (this.nodes == null) {
            this.compute();
        }
        return this.nodes;
    }

    protected void compute() {
        try {
            this.computeNodes();
            this.computeTransitions();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void computeNodes() throws ClientException {
        CoreSession session = this.document.getCoreSession();
        DocumentModelList children = session.getChildren(this.document.getRef());
        this.nodes = new ArrayList<GraphNode>(children.size());
        this.nodesById = new HashMap<String, GraphNode>();
        for (DocumentModel doc : children) {
            if (!doc.getType().equals("RouteNode")) continue;
            GraphNodeImpl node = new GraphNodeImpl(doc, this);
            String id = node.getId();
            if (this.nodesById.put(id, node) != null) {
                throw new DocumentRouteException("Duplicate nodes with id: " + id);
            }
            this.nodes.add(node);
        }
    }

    protected void computeTransitions() throws DocumentRouteException {
        for (GraphNode node : this.nodes) {
            List<GraphNode.Transition> tt = node.getOutputTransitions();
            for (GraphNode.Transition t : tt) {
                GraphNode target = this.getNode(t.target);
                target.initAddInputTransition(t);
            }
        }
    }

    @Override
    public GraphNode getStartNode() throws DocumentRouteException {
        for (GraphNode node : this.getNodes()) {
            if (!node.isStart()) continue;
            return node;
        }
        throw new DocumentRouteException("No start node for graph: " + this.getName());
    }

    @Override
    public GraphNode getNode(String id) {
        this.getNodes();
        GraphNode node = this.nodesById.get(id);
        if (node != null) {
            return node;
        }
        throw new IllegalArgumentException("No node with id: " + id + " in graph: " + this);
    }

    @Override
    public Map<String, Serializable> getVariables() {
        return GraphVariablesUtil.getVariables(this.document, "docri:variablesFacet");
    }

    @Override
    public void setVariables(Map<String, Serializable> map) {
        if (map.containsKey("_MAP_VAR_FORMAT_JSON") && ((Boolean)map.get("_MAP_VAR_FORMAT_JSON")).booleanValue()) {
            HashMap<String, String> vars = new HashMap<String, String>();
            map.remove("_MAP_VAR_FORMAT_JSON");
            for (String key : map.keySet()) {
                if (map.get(key) != null && !(map.get(key) instanceof String)) {
                    throw new ClientRuntimeException("The parameter 'map' should contain only Strings as it contains the marker '_MAP_VAR_FORMAT_JSON' ");
                }
                vars.put(key, (String)((Object)map.get(key)));
            }
            GraphVariablesUtil.setJSONVariables(this.document, "docri:variablesFacet", vars);
        } else {
            GraphVariablesUtil.setVariables(this.document, "docri:variablesFacet", map);
        }
    }

    @Override
    public void setJSONVariables(Map<String, String> map) {
        GraphVariablesUtil.setJSONVariables(this.document, "docri:variablesFacet", map);
    }

    @Override
    public DocumentModelList getAttachedDocumentModels() {
        try {
            List ids = (List)((Object)this.document.getPropertyValue("docri:participatingDocuments"));
            ArrayList<IdRef> docRefs = new ArrayList<IdRef>();
            for (String id : ids) {
                docRefs.add(new IdRef(id));
            }
            return this.document.getCoreSession().getDocuments(docRefs.toArray(new DocumentRef[0]));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getAvailabilityFilter() {
        try {
            return (String)((Object)this.document.getPropertyValue("docri:availabilityFilter"));
        }
        catch (ClientException e) {
            return null;
        }
    }

    @Override
    public boolean hasParentRoute() {
        try {
            String parentRouteInstanceId = (String)((Object)this.document.getPropertyValue("docri:parentRouteInstanceId"));
            return !StringUtils.isEmpty((String)parentRouteInstanceId);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void resumeParentRoute(CoreSession session) {
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        try {
            String parentRouteInstanceId = (String)((Object)this.document.getPropertyValue("docri:parentRouteInstanceId"));
            String parentRouteNodeId = (String)((Object)this.document.getPropertyValue("docri:parentRouteNodeId"));
            routing.resumeInstance(parentRouteInstanceId, parentRouteNodeId, null, null, session);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

