/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.directory;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.jaxrs.io.directory.DirectoryEntry;
import org.nuxeo.ecm.restapi.server.jaxrs.directory.DirectorySessionRunner;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="directoryObject")
public class DirectoryObject
extends DefaultObject {
    private Directory directory;

    protected void initialize(Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("Directory Object takes one parameter");
        }
        try {
            String dirName = (String)args[0];
            this.directory = ((DirectoryService)Framework.getLocalService(DirectoryService.class)).getDirectory(dirName);
            if (this.directory == null) {
                throw new WebResourceNotFoundException("Directory " + dirName + " was not found");
            }
        }
        catch (DirectoryException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    public List<DirectoryEntry> getDirectoryEntries() {
        return DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<List<DirectoryEntry>>(){

            @Override
            List<DirectoryEntry> run(Session session) throws ClientException {
                DocumentModelList entries = session.getEntries();
                ArrayList<DirectoryEntry> dirEntries = new ArrayList<DirectoryEntry>();
                for (DocumentModel doc : entries) {
                    dirEntries.add(new DirectoryEntry(DirectoryObject.this.directory.getName(), doc));
                }
                return dirEntries;
            }
        });
    }

    @POST
    public Response addEntry(final DirectoryEntry entry) {
        this.checkEditGuards();
        DirectoryEntry result = DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<DirectoryEntry>(){

            @Override
            DirectoryEntry run(Session session) throws ClientException {
                DocumentModel docEntry = session.createEntry(entry.getDocumentModel());
                return new DirectoryEntry(DirectoryObject.this.directory.getName(), docEntry);
            }
        });
        return Response.ok((Object)result).status(Response.Status.CREATED).build();
    }

    void checkEditGuards() {
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!currentUser.isAdministrator() && !currentUser.isMemberOf("powerusers")) {
            throw new WebSecurityException("Not allowed to edit directory");
        }
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        try {
            if (this.directory.getName().equals(um.getUserDirectoryName()) || this.directory.getName().equals(um.getGroupDirectoryName())) {
                throw new WebSecurityException("Not allowed to edit user/group directories, please use user/group endpoints");
            }
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @Path(value="{entryId}")
    public Object getEntry(final @PathParam(value="entryId") String entryId) {
        return DirectorySessionRunner.withDirectorySession(this.directory, new DirectorySessionRunner<Object>(){

            @Override
            Object run(Session session) throws ClientException {
                DocumentModel entry = session.getEntry(entryId);
                if (entry == null) {
                    throw new WebResourceNotFoundException("Entry not found");
                }
                return DirectoryObject.this.newObject("directoryEntry", new Object[]{new DirectoryEntry(DirectoryObject.this.directory.getName(), entry)});
            }
        });
    }
}

