/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.api;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;

public class ExecResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String commandLine;
    protected final List<String> output;
    protected final long execTime;
    protected boolean success;
    protected final CommandException error;
    protected int returnCode;

    public ExecResult(String commandLine, List<String> output, long execTime, int returnCode) {
        this.commandLine = commandLine;
        this.execTime = execTime;
        this.output = output;
        this.returnCode = returnCode;
        this.success = returnCode == 0;
        this.error = !this.success ? new CommandException(String.format("Error code %d return by command: %s\n%s", returnCode, commandLine, StringUtils.join(output, (String)"\n  "))) : null;
    }

    public ExecResult(String commandLine, Exception error) {
        this.commandLine = commandLine;
        this.execTime = 0L;
        this.output = null;
        this.success = false;
        this.error = new CommandException(String.format("Error while running command: %s", commandLine), error);
    }

    public List<String> getOutput() {
        return this.output;
    }

    public long getExecTime() {
        return this.execTime;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public CommandException getError() {
        return this.error;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getCommandLine() {
        return this.commandLine;
    }
}

