/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.io.Serializable;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="command")
public class CommandLineDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected boolean enabled;
    protected boolean available;
    @XNode(value="commandLine")
    protected String command;
    @XNode(value="parameterString")
    protected String parameterString;
    @XNode(value="winParameterString")
    protected String winParameterString;
    @XNode(value="winCommand")
    protected String winCommand;
    @XNode(value="tester")
    protected String tester;
    @XNode(value="readOutput")
    protected boolean readOutput = true;
    @XNode(value="installationDirective")
    protected String installationDirective;
    protected String installErrorMessage;

    public String getInstallErrorMessage() {
        return this.installErrorMessage;
    }

    public void setInstallErrorMessage(String installErrorMessage) {
        this.installErrorMessage = installErrorMessage;
    }

    public String getName() {
        if (this.name == null) {
            return this.getCommand();
        }
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    public String getCommand() {
        if (this.winCommand == null) {
            return this.command;
        }
        if (CommandLineDescriptor.isWindows()) {
            return this.winCommand;
        }
        return this.command;
    }

    public String getInstallationDirective() {
        return this.installationDirective;
    }

    public String getTester() {
        return this.tester;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean getReadOutput() {
        return this.readOutput;
    }

    public String getParametersString() {
        if (CommandLineDescriptor.isWindows() && this.winParameterString != null) {
            return this.winParameterString;
        }
        return this.parameterString;
    }

    public String getExecutor() {
        return "ShellExecutor";
    }
}

