/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restlet.data.CharacterSet;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;

public class HttpUtils {
    public Appendable appendComment(CharSequence source, Appendable destination) throws IOException {
        destination.append('(');
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '(') {
                destination.append("\\(");
                continue;
            }
            if (c == ')') {
                destination.append("\\)");
                continue;
            }
            if (c == '\\') {
                destination.append("\\\\");
                continue;
            }
            destination.append(c);
        }
        destination.append(')');
        return destination;
    }

    public static Parameter createParameter(CharSequence name, CharSequence value) throws IOException {
        if (value != null) {
            return new Parameter(((Object)name).toString(), ((Object)value).toString());
        }
        return new Parameter(((Object)name).toString(), null);
    }

    public static Appendable appendQuote(CharSequence source, Appendable destination) throws IOException {
        destination.append('\"');
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\"') {
                destination.append("\\\"");
                continue;
            }
            if (c == '\\') {
                destination.append("\\\\");
                continue;
            }
            destination.append(c);
        }
        destination.append('\"');
        return destination;
    }

    public static Appendable appendUriEncoded(CharSequence source, Appendable destination, CharacterSet characterSet) throws IOException {
        destination.append(Reference.encode(((Object)source).toString(), characterSet));
        return destination;
    }

    public static void formatProduct(CharSequence nameToken, CharSequence versionToken, Appendable destination) throws IOException {
        if (!HttpUtils.isToken(nameToken)) {
            throw new IllegalArgumentException("Invalid product name detected. Only token characters are allowed.");
        }
        destination.append(nameToken);
        if (versionToken != null) {
            if (!HttpUtils.isToken(versionToken)) {
                throw new IllegalArgumentException("Invalid product version detected. Only token characters are allowed.");
            }
            destination.append('/').append(versionToken);
        }
    }

    public static boolean isAsciiChar(int character) {
        return character >= 0 && character <= 127;
    }

    public static boolean isUpperCase(int character) {
        return character >= 65 && character <= 90;
    }

    public static boolean isLowerCase(int character) {
        return character >= 97 && character <= 122;
    }

    public static boolean isAlpha(int character) {
        return HttpUtils.isUpperCase(character) || HttpUtils.isLowerCase(character);
    }

    public static boolean isDigit(int character) {
        return character >= 48 && character <= 57;
    }

    public static boolean isControlChar(int character) {
        return character >= 0 && character <= 31 || character == 127;
    }

    public static boolean isCarriageReturn(int character) {
        return character == 13;
    }

    public static boolean isLineFeed(int character) {
        return character == 10;
    }

    public static boolean isSpace(int character) {
        return character == 32;
    }

    public static boolean isHorizontalTab(int character) {
        return character == 9;
    }

    public static boolean isDoubleQuote(int character) {
        return character == 34;
    }

    public static boolean isText(int character) {
        return HttpUtils.isAsciiChar(character) && !HttpUtils.isControlChar(character);
    }

    public static boolean isSeparator(int character) {
        switch (character) {
            case 9: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTokenChar(int character) {
        return HttpUtils.isText(character) && !HttpUtils.isSeparator(character);
    }

    public static boolean isToken(CharSequence token) {
        for (int i = 0; i < token.length(); ++i) {
            if (HttpUtils.isTokenChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Parameter readHeader(InputStream is, StringBuilder sb) throws IOException {
        Parameter result = null;
        int next = is.read();
        if (HttpUtils.isCarriageReturn(next)) {
            next = is.read();
            if (!HttpUtils.isLineFeed(next)) {
                throw new IOException("Invalid end of headers. Line feed missing after the carriage return.");
            }
        } else {
            result = new Parameter();
            while (next != -1 && next != 58) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header name. End of stream reached too early.");
            }
            result.setName(sb.toString());
            sb.delete(0, sb.length());
            next = is.read();
            while (HttpUtils.isSpace(next)) {
                next = is.read();
            }
            while (next != -1 && !HttpUtils.isCarriageReturn(next)) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header value. End of stream reached too early.");
            }
            next = is.read();
            if (HttpUtils.isLineFeed(next)) {
                result.setValue(sb.toString());
                sb.delete(0, sb.length());
            } else {
                throw new IOException("Unable to parse the HTTP header value. The carriage return must be followed by a line feed.");
            }
        }
        return result;
    }

    public static void writeHeader(Parameter header, OutputStream os) throws IOException {
        os.write(header.getName().getBytes());
        os.write(58);
        os.write(32);
        os.write(header.getValue().getBytes());
        os.write(13);
        os.write(10);
    }
}

