/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.util;

import com.noelios.restlet.Engine;
import com.noelios.restlet.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.util.DateUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityUtils {
    public static String format(ChallengeRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme().getTechnicalName());
        if (request.getRealm() != null) {
            sb.append(" realm=\"").append(request.getRealm()).append('\"');
        }
        return sb.toString();
    }

    public static String format(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        String secret;
        StringBuilder sb = new StringBuilder();
        sb.append(challenge.getScheme().getTechnicalName()).append(' ');
        String string = secret = challenge.getSecret() == null ? null : new String(challenge.getSecret());
        if (challenge.getCredentials() != null) {
            sb.append(challenge.getCredentials());
        } else if (challenge.getScheme().equals(ChallengeScheme.HTTP_AWS)) {
            String contentType;
            String contentMd5;
            String methodName = request.getMethod().getName();
            String date = "";
            if (httpHeaders.getFirstValue("X-Amz-Date", true) == null && (date = httpHeaders.getFirstValue("Date", true)) == null) {
                date = DateUtils.format(new Date(), DateUtils.FORMAT_RFC_1123.get(0));
                httpHeaders.add("Date", date);
            }
            if ((contentMd5 = httpHeaders.getFirstValue("Content-MD5", true)) == null) {
                contentMd5 = "";
            }
            if ((contentType = httpHeaders.getFirstValue("Content-Type", true)) == null) {
                boolean applyPatch = false;
                String jvmVendor = System.getProperty("java.vm.vendor");
                if (jvmVendor != null && jvmVendor.toLowerCase().startsWith("sun")) {
                    int majorVersionNumber = Engine.getJavaMajorVersion();
                    int minorVersionNumber = Engine.getJavaMinorVersion();
                    if (majorVersionNumber == 1) {
                        if (minorVersionNumber < 5) {
                            applyPatch = true;
                        } else if (minorVersionNumber == 5) {
                            applyPatch = Engine.getJavaUpdateVersion() < 10;
                        }
                    }
                }
                contentType = applyPatch && !request.getMethod().equals(Method.PUT) ? "application/x-www-form-urlencoded" : "";
            }
            String canonicalizedAmzHeaders = SecurityUtils.getCanonicalizedAmzHeaders(httpHeaders);
            String canonicalizedResource = SecurityUtils.getCanonicalizedResourceName(request.getResourceRef());
            StringBuilder rest = new StringBuilder();
            rest.append(methodName).append('\n').append(contentMd5).append('\n').append(contentType).append('\n').append(date).append('\n').append(canonicalizedAmzHeaders).append(canonicalizedResource);
            sb.append(challenge.getIdentifier()).append(':').append(Base64.encodeBytes(SecurityUtils.toHMac(rest.toString(), secret), 8));
        } else if (challenge.getScheme().equals(ChallengeScheme.HTTP_BASIC)) {
            try {
                String credentials = challenge.getIdentifier() + ':' + secret;
                sb.append(Base64.encodeBytes(credentials.getBytes("US-ASCII"), 8));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding, unable to encode credentials");
            }
        } else if (challenge.getScheme().equals(ChallengeScheme.SMTP_PLAIN)) {
            try {
                String credentials = "^@" + challenge.getIdentifier() + "^@" + secret;
                sb.append(Base64.encodeBytes(credentials.getBytes("US-ASCII"), 8));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding, unable to encode credentials");
            }
        } else {
            throw new IllegalArgumentException("Challenge scheme not supported by this implementation, or credentials not set for custom schemes.");
        }
        return sb.toString();
    }

    private static String getCanonicalizedAmzHeaders(Series<Parameter> requestHeaders) {
        TreeMap<String, String> amzHeaders = new TreeMap<String, String>();
        for (Parameter param : requestHeaders) {
            String headerName = param.getName().toLowerCase();
            if (!headerName.startsWith("x-amz-") || amzHeaders.containsKey(headerName)) continue;
            amzHeaders.put(headerName, requestHeaders.getValues(headerName));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : amzHeaders.entrySet()) {
            sb.append((String)entry.getKey()).append(':').append((String)entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    private static String getCanonicalizedResourceName(Reference resourceRef) {
        StringBuilder sb = new StringBuilder();
        sb.append(resourceRef.getPath());
        Form query = resourceRef.getQueryAsForm();
        if (query.getFirst("acl", true) != null) {
            sb.append("?acl");
        } else if (query.getFirst("torrent", true) != null) {
            sb.append("?torrent");
        }
        return sb.toString();
    }

    public static ChallengeRequest parseRequest(String header) {
        int space;
        ChallengeRequest result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String realm = header.substring(space + 1);
            int equals = realm.indexOf(61);
            String realmValue = realm.substring(equals + 2, realm.length() - 1);
            result = new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme), realmValue);
        }
        return result;
    }

    public static ChallengeResponse parseResponse(Request request, Logger logger, String header) {
        int space;
        ChallengeResponse result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String credentials = header.substring(space + 1);
            result = new ChallengeResponse(new ChallengeScheme("HTTP_" + scheme, scheme), credentials);
            if (result.getScheme().equals(ChallengeScheme.HTTP_BASIC)) {
                try {
                    byte[] credentialsEncoded = Base64.decode(result.getCredentials());
                    if (credentialsEncoded == null) {
                        logger.warning("Cannot decode credentials: " + result.getCredentials());
                        return null;
                    }
                    credentials = new String(credentialsEncoded, "US-ASCII");
                    int separator = credentials.indexOf(58);
                    if (separator == -1) {
                        logger.warning("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
                    } else {
                        result.setIdentifier(credentials.substring(0, separator));
                        result.setSecret(credentials.substring(separator + 1));
                        if (logger != null) {
                            logger.info("Basic HTTP authentication succeeded: identifier=" + result.getIdentifier() + ".");
                        }
                    }
                }
                catch (UnsupportedEncodingException e) {
                    logger.log(Level.WARNING, "Unsupported encoding error", e);
                }
            } else {
                logger.log(Level.FINE, "Authentication impossible: scheme not supported: " + result.getScheme().getName() + ". Please override the Guard.authenticate method.");
            }
        }
        return result;
    }

    public static byte[] toHMac(String source, String secretKey) {
        byte[] result = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            result = mac.doFinal(source.getBytes());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("Could not find the SHA-1 algorithm. HMac conversion failed.", nsae);
        }
        catch (InvalidKeyException ike) {
            throw new RuntimeException("Invalid key exception detected. HMac conversion failed.", ike);
        }
        return result;
    }
}

