/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.task;

import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.task.dashboard.DashBoardItemImpl;

@Operation(id="Workflow.GetTask", category="Services", label="Get user tasks", since="5.4", description="List tasks assigned to this user or one of its group.Task properties are serialized using JSON and returned in a Blob.")
public class GetUserTasks {
    public static final String ID = "Workflow.GetTask";
    private static final Log log = LogFactory.getLog(Log.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession repo;
    @Context
    protected TaskService taskService;

    @OperationMethod
    public Blob run() throws Exception {
        List tasks = this.taskService.getCurrentTaskInstances(this.repo);
        if (tasks == null) {
            return null;
        }
        JSONArray rows = new JSONArray();
        for (Task task : tasks) {
            DocumentModel doc = null;
            try {
                doc = this.taskService.getTargetDocumentModel(task, this.repo);
            }
            catch (Exception e) {
                log.warn((Object)("Cannot get doc for task " + task.getId()), (Throwable)e);
            }
            if (doc == null) {
                log.warn((Object)String.format("User '%s' has a task of type '%s' on an unexisting or invisible document", this.principal().getName(), task.getName()));
                continue;
            }
            DashBoardItemImpl item = new DashBoardItemImpl(task, doc, null);
            JSONObject obj = item.asJSON();
            rows.add((Object)obj);
        }
        return new StringBlob(rows.toString(), "application/json");
    }

    protected NuxeoPrincipal principal() {
        return (NuxeoPrincipal)this.ctx.getPrincipal();
    }
}

