/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.binary.Binary;

public class StateHelper {
    private StateHelper() {
    }

    public static boolean isScalar(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Long || value instanceof Double || value instanceof Calendar || value instanceof Binary;
    }

    public static boolean equalsStrict(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a instanceof State && b instanceof State) {
            return StateHelper.equalsStrict((State)a, (State)b);
        }
        if (a instanceof List && b instanceof List) {
            List la = (List)a;
            List lb = (List)b;
            return StateHelper.equalsStrict(la, lb);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return StateHelper.equalsStrict((Object[])a, (Object[])b);
        }
        if (a instanceof State.ListDiff && b instanceof State.ListDiff) {
            State.ListDiff lda = (State.ListDiff)a;
            State.ListDiff ldb = (State.ListDiff)b;
            return lda.isArray == ldb.isArray && StateHelper.equalsStrict(lda.diff, ldb.diff) && StateHelper.equalsStrict(lda.rpush, ldb.rpush);
        }
        if (StateHelper.isScalar(a) && StateHelper.isScalar(b)) {
            return a.equals(b);
        }
        return false;
    }

    public static boolean equalsStrict(State a, State b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        if (!a.keySet().equals(b.keySet())) {
            return false;
        }
        for (Map.Entry<String, Serializable> en : a.entrySet()) {
            Serializable vb;
            String key = en.getKey();
            Serializable va = en.getValue();
            if (StateHelper.equalsStrict(va, vb = b.get(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsStrict(Object[] a, Object[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equalsStrict(List<Serializable> a, List<Serializable> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Serializable> ita = a.iterator();
        Iterator<Serializable> itb = b.iterator();
        while (ita.hasNext()) {
            if (StateHelper.equalsStrict(ita.next(), itb.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLoose(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a instanceof State && b instanceof State || a instanceof State && b == null || a == null && b instanceof State) {
            return StateHelper.equalsLoose((State)a, (State)b);
        }
        if (a instanceof List && b instanceof List || a instanceof List && b == null || a == null && b instanceof List) {
            List la = (List)a;
            List lb = (List)b;
            return StateHelper.equalsLoose(la, lb);
        }
        if (a instanceof Object[] && b instanceof Object[] || a instanceof Object[] && b == null || a == null && b instanceof Object[]) {
            return StateHelper.equalsLoose((Object[])a, (Object[])b);
        }
        if (a instanceof State.ListDiff && b instanceof State.ListDiff) {
            State.ListDiff lda = (State.ListDiff)a;
            State.ListDiff ldb = (State.ListDiff)b;
            return lda.isArray == ldb.isArray && StateHelper.equalsLoose(lda.diff, ldb.diff) && StateHelper.equalsLoose(lda.rpush, ldb.rpush);
        }
        if (StateHelper.isScalar(a) && StateHelper.isScalar(b)) {
            return a.equals(b);
        }
        return false;
    }

    public static boolean equalsLoose(State a, State b) {
        Serializable vb;
        if (a == null) {
            a = State.EMPTY;
        }
        if (b == null) {
            b = State.EMPTY;
        }
        for (Map.Entry<String, Serializable> en : a.entrySet()) {
            String key;
            Serializable va = en.getValue();
            if (va == null || StateHelper.equalsLoose(va, vb = b.get(key = en.getKey()))) continue;
            return false;
        }
        for (Map.Entry<String, Serializable> en : b.entrySet()) {
            String key = en.getKey();
            Serializable va = a.get(key);
            if (va != null || StateHelper.equalsLoose(null, vb = en.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLoose(Object[] a, Object[] b) {
        if (a != null && a.length == 0) {
            a = null;
        }
        if (b != null && b.length == 0) {
            b = null;
        }
        return Arrays.equals(a, b);
    }

    public static boolean equalsLoose(List<Serializable> a, List<Serializable> b) {
        if (a != null && a.isEmpty()) {
            a = null;
        }
        if (b != null && b.isEmpty()) {
            b = null;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<Serializable> ita = a.iterator();
        Iterator<Serializable> itb = b.iterator();
        while (ita.hasNext()) {
            if (StateHelper.equalsLoose(ita.next(), itb.next())) continue;
            return false;
        }
        return true;
    }

    public static Serializable deepCopy(Object value) {
        return StateHelper.deepCopy(value, false);
    }

    public static Serializable deepCopy(Object value, boolean threadSafe) {
        if (value == null) {
            return (Serializable)value;
        }
        if (value instanceof State) {
            return StateHelper.deepCopy((State)value, threadSafe);
        }
        if (value instanceof List) {
            List list = (List)value;
            return (Serializable)((Object)StateHelper.deepCopy(list, threadSafe));
        }
        if (value instanceof Object[]) {
            return (Serializable)((Object[])value).clone();
        }
        if (!StateHelper.isScalar(value)) {
            throw new UnsupportedOperationException("Cannot deep copy: " + value.getClass().getName());
        }
        return (Serializable)value;
    }

    public static State deepCopy(State state) {
        return StateHelper.deepCopy(state, false);
    }

    public static State deepCopy(State state, boolean threadSafe) {
        State copy = new State(state.size(), threadSafe);
        for (Map.Entry<String, Serializable> en : state.entrySet()) {
            copy.put(en.getKey(), StateHelper.deepCopy(en.getValue(), threadSafe));
        }
        return copy;
    }

    public static List<Serializable> deepCopy(List<Serializable> list) {
        return StateHelper.deepCopy(list, false);
    }

    public static List<Serializable> deepCopy(List<Serializable> list, boolean threadSafe) {
        CopyOnWriteArrayList<Serializable> copy = threadSafe ? new CopyOnWriteArrayList() : new ArrayList(list.size());
        for (Serializable v : list) {
            copy.add(StateHelper.deepCopy(v, threadSafe));
        }
        return copy;
    }

    public static Serializable diff(Object a, Object b) {
        if (StateHelper.equalsLoose(a, b)) {
            return State.NOP;
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return StateHelper.diff((Object[])a, (Object[])b);
        }
        if (a instanceof List && b instanceof List) {
            List la = (List)a;
            List lb = (List)b;
            return StateHelper.diff(la, lb);
        }
        if (a instanceof State && b instanceof State) {
            State.StateDiff diff = StateHelper.diff((State)a, (State)b);
            return diff.isEmpty() ? State.NOP : diff;
        }
        return (Serializable)b;
    }

    public static Serializable diff(Object[] a, Object[] b) {
        List<Object> lb;
        List<Object> la = Arrays.asList(a);
        Serializable diff = StateHelper.diff(la, lb = Arrays.asList(b));
        if (diff instanceof List) {
            return b;
        }
        State.ListDiff listDiff = (State.ListDiff)diff;
        listDiff.isArray = true;
        return listDiff;
    }

    public static Serializable diff(List<Object> a, List<Object> b) {
        boolean doDiff;
        State.ListDiff listDiff = new State.ListDiff();
        listDiff.isArray = false;
        int aSize = a.size();
        int bSize = b.size();
        boolean doRPush = aSize > 0 && aSize < bSize;
        boolean bl = doDiff = aSize == bSize || doRPush;
        if (!doDiff) {
            return (Serializable)((Object)b);
        }
        int len = Math.min(aSize, bSize);
        ArrayList<Object> diff = new ArrayList<Object>(len);
        int nops = 0;
        int diffs = 0;
        for (int i = 0; i < len; ++i) {
            Serializable elemDiff = StateHelper.diff(a.get(i), b.get(i));
            if (elemDiff == State.NOP) {
                ++nops;
            } else if (elemDiff instanceof State.StateDiff) {
                ++diffs;
            }
            diff.add(elemDiff);
        }
        if (nops == len) {
            diff = null;
        } else if (diffs == 0) {
            return (Serializable)((Object)b);
        }
        listDiff.diff = diff;
        if (doRPush) {
            ArrayList<Object> rpush = new ArrayList<Object>(bSize - aSize);
            for (int i = aSize; i < bSize; ++i) {
                rpush.add(b.get(i));
            }
            listDiff.rpush = rpush;
        }
        return listDiff;
    }

    public static State.StateDiff diff(State a, State b) {
        Serializable vb;
        State.StateDiff diff = new State.StateDiff();
        for (Map.Entry<String, Serializable> en : a.entrySet()) {
            Serializable va = en.getValue();
            if (va == null) continue;
            String key = en.getKey();
            vb = b.get(key);
            if (vb == null) {
                diff.put(key, null);
                continue;
            }
            Serializable elemDiff = StateHelper.diff(va, vb);
            if (elemDiff == State.NOP) continue;
            diff.put(key, elemDiff);
        }
        for (Map.Entry<String, Serializable> en : b.entrySet()) {
            String key = en.getKey();
            Serializable va = a.get(key);
            if (va != null || StateHelper.equalsLoose(null, vb = en.getValue())) continue;
            diff.put(key, vb);
        }
        return diff;
    }
}

