/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.binary;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.nuxeo.ecm.core.storage.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.binary.BinaryManagerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String digest;
    protected final String repoName;
    protected transient File file;
    protected long length;

    public Binary(File file, String digest) {
        this(file, digest, null);
    }

    protected Binary(String digest, String reponame) {
        this(null, digest, reponame);
    }

    public Binary(File file, String digest, String repoName) {
        this.file = file;
        this.digest = digest;
        this.repoName = repoName;
        this.length = -1L;
    }

    protected long computeLength() {
        if (this.file == null) {
            return -1L;
        }
        return this.file.length();
    }

    public long getLength() {
        if (this.length == -1L) {
            this.length = this.computeLength();
        }
        return this.length;
    }

    public String getDigest() {
        return this.digest;
    }

    public InputStream getStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.digest + ')';
    }

    public StreamSource getStreamSource() {
        return new FileSource(this.file);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.defaultWriteObject();
        if (this.repoName == null) {
            oos.writeObject(this.file);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.file = this.repoName == null ? (File)ois.readObject() : this.fetchData();
    }

    protected File fetchData() {
        BinaryManagerService bms = (BinaryManagerService)((Object)Framework.getLocalService(BinaryManagerService.class));
        BinaryManager mgr = bms.getBinaryManager(this.repoName);
        return mgr.getBinary((String)this.digest).file;
    }
}

