/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.vocabulary.RDF;

class ReificationStatementMask {
    protected int mask = 0;
    public static final int HasSubj = 1;
    public static final int HasPred = 2;
    public static final int HasObj = 4;
    public static final int HasType = 8;
    public static final int HasSPOT = 15;
    public static final int IsStmt = 16;
    public static final int HasNada = 0;

    public boolean hasSubj() {
        return (this.mask & 1) == 1;
    }

    public boolean hasPred() {
        return (this.mask & 2) == 2;
    }

    public boolean hasObj() {
        return (this.mask & 4) == 4;
    }

    public boolean hasType() {
        return (this.mask & 8) == 8;
    }

    public boolean hasSPOT() {
        return (this.mask & 0xF) == 15;
    }

    public boolean isStmt() {
        return (this.mask & 0x10) == 16;
    }

    public boolean hasNada() {
        return this.mask == 0;
    }

    public boolean hasOneBit() {
        return this.mask == 1 || this.mask == 2 || this.mask == 4 || this.mask == 8;
    }

    ReificationStatementMask(Triple t) {
        Node p = t.getPredicate();
        if (p != null) {
            Node o;
            if (p.equals(RDF.Nodes.subject)) {
                this.mask = 1;
            } else if (p.equals(RDF.Nodes.predicate)) {
                this.mask = 2;
            } else if (p.equals(RDF.Nodes.object)) {
                this.mask = 4;
            } else if (p.equals(RDF.Nodes.type) && (o = t.getObject()).equals(RDF.Nodes.Statement)) {
                this.mask = 8;
            }
        }
    }

    ReificationStatementMask() {
    }

    public void setMerge(ReificationStatementMask m) {
        this.mask |= m.mask;
    }

    public void setHasType() {
        this.mask |= 8;
    }

    public void setMask(boolean hasSubj, boolean hasProp, boolean hasObj, boolean hasType) {
        if (hasSubj) {
            this.mask |= 1;
        }
        if (hasProp) {
            this.mask |= 2;
        }
        if (hasObj) {
            this.mask |= 4;
        }
        if (hasType) {
            this.mask |= 8;
        }
    }

    public void setHasSubj() {
        this.mask |= 1;
    }

    public void setHasPred() {
        this.mask |= 2;
    }

    public void setHasObj() {
        this.mask |= 4;
    }

    public void setIsStmt() {
        this.mask |= 0x10;
    }

    public boolean hasIntersect(ReificationStatementMask m) {
        return (this.mask & m.mask) != 0;
    }

    public boolean equals(ReificationStatementMask m) {
        return this.mask == m.mask;
    }
}

