/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import jdbm.RecordManager;
import jdbm.helper.LongSerializer;
import jdbm.helper.Serializer;
import jdbm.helper.StringComparator;
import org.apache.directory.server.core.partition.impl.btree.MasterTable;
import org.apache.directory.server.core.partition.impl.btree.jdbm.AttributesSerializer;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.schema.SerializableComparator;

public class JdbmMasterTable
extends JdbmTable
implements MasterTable {
    private static final StringComparator STRCOMP = new StringComparator();
    private static final SerializableComparator LONG_COMPARATOR = new SerializableComparator("1.3.6.1.4.1.18060.0.4.1.1.2"){
        private static final long serialVersionUID = 4048791282048841016L;

        public int compare(Object o1, Object o2) {
            try {
                long thisVal = (Long)o1;
                long anotherVal = (Long)o2;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
            catch (NullPointerException npe) {
                if (o1 == null) {
                    throw new IllegalArgumentException("Argument 'obj1' is null");
                }
                throw new IllegalArgumentException("Argument 'obj2' is null");
            }
        }
    };
    private static final SerializableComparator STRING_COMPARATOR = new SerializableComparator("1.3.6.1.4.1.18060.0.4.1.1.3"){
        private static final long serialVersionUID = 3258689922792961845L;

        public int compare(Object o1, Object o2) {
            return STRCOMP.compare(o1, o2);
        }
    };
    private JdbmTable adminTbl = null;

    public JdbmMasterTable(RecordManager recMan) throws NamingException {
        super("master", recMan, LONG_COMPARATOR, (Serializer)LongSerializer.INSTANCE, new AttributesSerializer());
        this.adminTbl = new JdbmTable("admin", recMan, STRING_COMPARATOR, null, null);
        String seqValue = (String)this.adminTbl.get("__sequence__");
        if (null == seqValue) {
            this.adminTbl.put((Object)"__sequence__", "0");
        }
    }

    public Attributes get(Object id) throws NamingException {
        return (Attributes)super.get(id);
    }

    public Attributes put(Attributes entry, Object id) throws NamingException {
        return (Attributes)super.put(id, entry);
    }

    public Attributes delete(Object id) throws NamingException {
        return (Attributes)super.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCurrentId() throws NamingException {
        Long id = null;
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            id = new Long((String)this.adminTbl.get("__sequence__"));
            if (null == id) {
                this.adminTbl.put((Object)"__sequence__", "0");
                id = 0L;
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextId() throws NamingException {
        Long lastVal = null;
        Long nextVal = null;
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            lastVal = new Long((String)this.adminTbl.get("__sequence__"));
            if (null == lastVal) {
                this.adminTbl.put((Object)"__sequence__", "1");
                return 1L;
            }
            nextVal = lastVal + 1L;
            this.adminTbl.put((Object)"__sequence__", nextVal.toString());
        }
        return nextVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String property) throws NamingException {
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            return (String)this.adminTbl.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String property, String value) throws NamingException {
        JdbmTable jdbmTable = this.adminTbl;
        synchronized (jdbmTable) {
            this.adminTbl.put((Object)property, value);
        }
    }
}

