/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.xbean.naming.reference.SimpleReference;
import org.nuxeo.runtime.api.InitialContextAccessor;
import org.nuxeo.runtime.jtajca.NamingContext;
import org.nuxeo.runtime.jtajca.NamingContextFacade;
import org.nuxeo.runtime.jtajca.NamingContextFactory;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoContainerListener;
import org.nuxeo.runtime.metrics.MetricsService;

public class NuxeoContainer {
    protected static final Log log = LogFactory.getLog(NuxeoContainer.class);
    public static final String JNDI_TRANSACTION_MANAGER = "java:comp/TransactionManager";
    public static final String JNDI_USER_TRANSACTION = "java:comp/UserTransaction";
    public static final String JNDI_NUXEO_CONNECTION_MANAGER_PREFIX = "java:comp/NuxeoConnectionManager/";
    protected static TransactionManagerWrapper transactionManager;
    protected static UserTransaction userTransaction;
    protected static Map<String, ConnectionManagerWrapper> connectionManagers;
    private static final List<NuxeoContainerListener> listeners;
    private static InstallContext installContext;
    private static Context parentContext;
    private static Map<String, Object> parentEnvironment;
    protected static Context rootContext;
    protected static final MetricRegistry registry;
    protected static final Counter rollbackCount;
    protected static final Counter concurrentCount;
    protected static final Counter concurrentMaxCount;
    protected static final Timer transactionTimer;
    protected static final ConcurrentHashMap<Transaction, Timer.Context> timers;

    private NuxeoContainer() {
    }

    public static synchronized void install() throws NamingException {
        if (installContext != null) {
            throw new RuntimeException("Nuxeo container already installed");
        }
        NuxeoContainer.install(null);
    }

    public static synchronized void install(TransactionManagerConfiguration txconfig) throws NamingException {
        NuxeoContainer.installNaming();
        NuxeoContainer.installTransactionManager(txconfig);
    }

    protected static void installTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        transactionManager = NuxeoContainer.lookupTransactionManager();
        if (transactionManager == null) {
            if (config == null) {
                config = new TransactionManagerConfiguration();
            }
            NuxeoContainer.initTransactionManager(config);
            NuxeoContainer.addDeepBinding(rootContext, new CompositeName(JNDI_TRANSACTION_MANAGER), NuxeoContainer.getTransactionManagerReference());
            NuxeoContainer.addDeepBinding(rootContext, new CompositeName(JNDI_USER_TRANSACTION), NuxeoContainer.getUserTransactionReference());
        } else {
            userTransaction = new UserTransactionImpl((TransactionManager)transactionManager);
        }
    }

    public static synchronized ConnectionManagerWrapper installConnectionManager(NuxeoConnectionManagerConfiguration config) {
        String name = config.getName();
        ConnectionManagerWrapper cm = connectionManagers.get(name);
        if (cm != null) {
            return cm;
        }
        cm = NuxeoContainer.initConnectionManager(config);
        if (rootContext != null) {
            String jndiName = JNDI_NUXEO_CONNECTION_MANAGER_PREFIX + name;
            try {
                NuxeoContainer.addDeepBinding(rootContext, new CompositeName(jndiName), NuxeoContainer.getConnectionManagerReference(name));
            }
            catch (NamingException e) {
                log.error((Object)("Cannot bind in JNDI connection manager " + config.getName() + " to name " + jndiName));
            }
        }
        return cm;
    }

    public static synchronized boolean isInstalled() {
        return installContext != null;
    }

    public static synchronized InstallContext getInstallContext() {
        return installContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void uninstall() throws NamingException {
        if (installContext == null) {
            throw new RuntimeException("Nuxeo container not installed");
        }
        try {
            NamingException errors = new NamingException("Cannot shutdown connection managers");
            for (ConnectionManagerWrapper cm : connectionManagers.values()) {
                try {
                    cm.dispose();
                }
                catch (Exception cause) {
                    errors.addSuppressed(cause);
                }
            }
            if (errors.getSuppressed().length > 0) {
                throw errors;
            }
        }
        finally {
            NuxeoContainer.uninstallNaming();
            transactionManager = null;
            userTransaction = null;
            connectionManagers.clear();
        }
    }

    public static synchronized void installNaming() throws NamingException {
        installContext = new InstallContext();
        log.trace((Object)"Installing nuxeo container", (Throwable)installContext);
        NuxeoContainer.setupRootContext();
        NuxeoContainer.setAsInitialContext();
    }

    public static synchronized void uninstallNaming() {
        log.trace((Object)"Uninstalling nuxeo container", (Throwable)installContext);
        try {
            NuxeoContainer.cleanupContext(rootContext);
        }
        catch (NamingException cause) {
            log.error((Object)"Cannot cleanup root context", (Throwable)cause);
        }
        installContext = null;
        parentContext = null;
        rootContext = null;
        NuxeoContainer.revertSetAsInitialContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(NuxeoContainerListener listener) {
        List<NuxeoContainerListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
        for (Map.Entry<String, ConnectionManagerWrapper> entry : connectionManagers.entrySet()) {
            listener.handleNewConnectionManager(entry.getKey(), entry.getValue().cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(NuxeoContainerListener listener) {
        List<NuxeoContainerListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    protected static void setupRootContext() throws NamingException {
        parentContext = InitialContextAccessor.getInitialContext();
        if (parentContext != null) {
            if (InitialContextAccessor.isWritable((Context)parentContext)) {
                rootContext = parentContext;
                return;
            }
            rootContext = new NamingContextFacade(parentContext);
            log.warn((Object)"Chaining naming spaces, can break your application server");
            return;
        }
        rootContext = new NamingContext();
    }

    public static Context getRootContext() {
        return rootContext;
    }

    protected static void setAsInitialContext() {
        String key = "java.naming.factory.initial";
        parentEnvironment.put(key, System.getProperty(key));
        key = "java.naming.factory.url.pkgs";
        parentEnvironment.put(key, System.getProperty(key));
        System.setProperty("java.naming.factory.initial", NamingContextFactory.class.getName());
        System.setProperty("java.naming.factory.url.pkgs", "org.nuxeo.runtime.jtajca");
    }

    protected static void revertSetAsInitialContext() {
        Iterator<Map.Entry<String, Object>> iterator = parentEnvironment.entrySet().iterator();
        Properties props = System.getProperties();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            iterator.remove();
            String key = entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                props.remove(key);
                continue;
            }
            props.setProperty(key, value);
        }
    }

    public static void addDeepBinding(String name, Object obj) throws NamingException {
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(name), obj);
    }

    protected static void addDeepBinding(Context dir, CompositeName comp, Object obj) throws NamingException {
        Context subdir;
        Name name = comp.getPrefix(1);
        if (comp.size() == 1) {
            NuxeoContainer.addBinding(dir, name, obj);
            return;
        }
        try {
            subdir = (Context)dir.lookup(name);
        }
        catch (NamingException e) {
            subdir = dir.createSubcontext(name);
        }
        NuxeoContainer.addDeepBinding(subdir, (CompositeName)comp.getSuffix(1), obj);
    }

    protected static void addBinding(Context dir, Name name, Object obj) throws NamingException {
        try {
            dir.rebind(name, obj);
        }
        catch (NamingException e) {
            dir.bind(name, obj);
        }
    }

    protected static void cleanupContext(Context context) throws NamingException {
        NamingEnumeration<NameClassPair> names = context.list("");
        NamingException errors = new NamingException("Cannot cleanup context");
        while (true) {
            try {
                while (true) {
                    if (!names.hasMore()) {
                        return;
                    }
                    String name = names.next().getName();
                    Object object = context.lookup(name);
                    if (object instanceof Context) {
                        NuxeoContainer.cleanupContext((Context)object);
                    }
                    context.unbind(name);
                }
            }
            catch (NamingException cause) {
                errors.addSuppressed(cause);
                continue;
            }
            break;
        }
    }

    protected static void removeBinding(String name) throws NamingException {
        rootContext.unbind(name);
    }

    protected static <T> T resolveBinding(String name) throws NamingException {
        InitialContext ctx = new InitialContext();
        try {
            return (T)ctx.lookup("java:comp/" + name);
        }
        catch (NamingException compe) {
            try {
                return (T)ctx.lookup("java:comp/env/" + name);
            }
            catch (NamingException enve) {
                return (T)ctx.lookup(name);
            }
        }
    }

    public static TransactionManager getTransactionManager() {
        return transactionManager;
    }

    protected static Reference getTransactionManagerReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getTransactionManager();
            }
        };
    }

    public static UserTransaction getUserTransaction() throws NamingException {
        return userTransaction;
    }

    protected static Reference getUserTransactionReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getUserTransaction();
            }
        };
    }

    public static ConnectionManager getConnectionManager(String repositoryName) {
        return connectionManagers.get(repositoryName);
    }

    public static void installConnectionManager(ConnectionManagerWrapper wrapper) {
        String name = wrapper.config.getName();
        if (connectionManagers.containsKey(name)) {
            log.error((Object)("Connection manager " + name + " already set up"), (Throwable)new Exception());
        }
        connectionManagers.put(name, wrapper);
        for (NuxeoContainerListener listener : listeners) {
            listener.handleNewConnectionManager(name, wrapper.cm);
        }
    }

    protected static Reference getConnectionManagerReference(final String name) {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getConnectionManager(name);
            }
        };
    }

    protected static synchronized TransactionManager initTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        TransactionManager tm = NuxeoContainer.createTransactionManager(config);
        transactionManager = new TransactionManagerWrapper(tm);
        userTransaction = new UserTransactionImpl((TransactionManager)transactionManager);
        return transactionManager;
    }

    protected static TransactionManagerWrapper lookupTransactionManager() {
        TransactionManager tm;
        try {
            tm = (TransactionManager)NuxeoContainer.resolveBinding("TransactionManager");
        }
        catch (NamingException e) {
            return null;
        }
        if (tm == null) {
            return null;
        }
        if (tm instanceof TransactionManagerWrapper) {
            return (TransactionManagerWrapper)tm;
        }
        return new TransactionManagerWrapper(tm);
    }

    public static synchronized ConnectionManagerWrapper initConnectionManager(NuxeoConnectionManagerConfiguration config) {
        ConnectionTrackingCoordinator coordinator = new ConnectionTrackingCoordinator();
        GenericConnectionManager cm = NuxeoContainer.createConnectionManager(coordinator, config);
        ConnectionManagerWrapper cmw = new ConnectionManagerWrapper(coordinator, (AbstractConnectionManager)cm, config);
        NuxeoContainer.installConnectionManager(cmw);
        return cmw;
    }

    public static synchronized void disposeConnectionManager(ConnectionManager mgr) throws Exception {
        ((ConnectionManagerWrapper)mgr).dispose();
    }

    public static synchronized void resetConnectionManager(String name) throws Exception {
        ConnectionManagerWrapper wrapper = connectionManagers.get(name);
        wrapper.reset();
        for (NuxeoContainerListener listener : listeners) {
            listener.handleConnectionManagerReset(name, wrapper.cm);
        }
    }

    public static synchronized void resetConnectionManager() throws Exception {
        Exception errors = new Exception("Cannot reset connection managers");
        for (String name : connectionManagers.keySet()) {
            try {
                NuxeoContainer.resetConnectionManager(name);
            }
            catch (Exception cause) {
                errors.addSuppressed(cause);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    protected static ConnectionManagerWrapper lookupConnectionManager(String repositoryName) {
        ConnectionManager cm;
        try {
            String jndiName = JNDI_NUXEO_CONNECTION_MANAGER_PREFIX + repositoryName;
            Object o = NuxeoContainer.resolveBinding(jndiName);
            cm = (ConnectionManager)o;
        }
        catch (NamingException e) {
            return null;
        }
        if (cm instanceof ConnectionManagerWrapper) {
            return (ConnectionManagerWrapper)cm;
        }
        log.warn((Object)"Connection manager not a wrapper, check your configuration");
        return null;
    }

    protected static TransactionManager createTransactionManager(TransactionManagerConfiguration config) {
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static GenericConnectionManager createConnectionManager(ConnectionTracker tracker, NuxeoConnectionManagerConfiguration config) {
        TransactionSupport transactionSupport = NuxeoContainer.createTransactionSupport(config);
        SinglePool poolingSupport = new SinglePool(config.getMaxPoolSize(), config.getMinPoolSize(), config.getBlockingTimeoutMillis(), config.getIdleTimeoutMinutes(), config.getMatchOne(), config.getMatchAll(), config.getSelectOneNoMatch());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return new GenericConnectionManager(transactionSupport, (PoolingSupport)poolingSupport, null, tracker, (RecoverableTransactionManager)transactionManager, config.getName(), classLoader);
    }

    protected static TransactionSupport createTransactionSupport(NuxeoConnectionManagerConfiguration config) {
        if (config.getXAMode()) {
            return new XATransactions(config.getUseTransactionCaching(), config.getUseThreadCaching());
        }
        return LocalTransactions.INSTANCE;
    }

    static {
        connectionManagers = new ConcurrentHashMap<String, ConnectionManagerWrapper>(8, 0.75f, 2);
        listeners = new ArrayList<NuxeoContainerListener>();
        parentEnvironment = new HashMap<String, Object>();
        registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        rollbackCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "rollbacks"}));
        concurrentCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "count"}));
        concurrentMaxCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "max"}));
        transactionTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "duration"}));
        timers = new ConcurrentHashMap();
    }

    public static class ConnectionManagerWrapper
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;
        protected ConnectionTrackingCoordinator coordinator;
        protected AbstractConnectionManager cm;
        protected final NuxeoConnectionManagerConfiguration config;

        public ConnectionManagerWrapper(ConnectionTrackingCoordinator coordinator, AbstractConnectionManager cm, NuxeoConnectionManagerConfiguration config) {
            this.coordinator = coordinator;
            this.cm = cm;
            this.config = config;
        }

        public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            return this.cm.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }

        public void reset() throws Exception {
            this.cm.doStop();
            this.cm = NuxeoContainer.createConnectionManager(this.coordinator, this.config);
        }

        public void dispose() throws Exception {
            connectionManagers.remove(this.config.getName());
            this.cm.doStop();
        }

        public NuxeoConnectionManagerConfiguration getConfiguration() {
            return this.config;
        }

        public Collection<ConnectionTrackingCoordinator.Context.Allocation> getCurrentThreadAllocations() {
            return this.coordinator.contextHolder.get().inuse.values();
        }

        public PoolingAttributes getPooling() {
            return this.cm.getPooling();
        }

        public void enterNoSharing() {
            this.coordinator.contextHolder.get().unshareable = true;
        }

        public void exitNoSharing() {
            this.coordinator.contextHolder.get().unshareable = false;
        }
    }

    public static class ConnectionTrackingCoordinator
    implements ConnectionTracker {
        protected final ThreadLocal<Context> contextHolder = new ThreadLocal<Context>(){

            @Override
            protected Context initialValue() {
                return new Context();
            }
        };

        public void handleObtained(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
            Context context = this.contextHolder.get();
            context.inuse.put(connectionInfo, new Context.Allocation(connectionInfo));
        }

        public void handleReleased(ConnectionTrackingInterceptor connectionTrackingInterceptor, ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
            Context context = this.contextHolder.get();
            context.inuse.remove(connectionInfo);
            if (context.inuse.isEmpty()) {
                this.contextHolder.remove();
            }
        }

        public void setEnvironment(ConnectionInfo connectionInfo, String key) {
            connectionInfo.setUnshareable(this.contextHolder.get().unshareable);
        }

        protected static class Context {
            protected boolean unshareable;
            protected final String threadName = Thread.currentThread().getName();
            protected final Map<ConnectionInfo, Allocation> inuse = new HashMap<ConnectionInfo, Allocation>();

            protected Context() {
            }

            protected void finalize() throws Throwable {
                try {
                    this.checkIsEmpty();
                }
                catch (AllocationErrors cause) {
                    LogFactory.getLog(ConnectionTrackingCoordinator.class).error((Object)"cleanup errors", (Throwable)cause);
                }
            }

            protected void checkIsEmpty() {
                if (!this.inuse.isEmpty()) {
                    throw new AllocationErrors(this);
                }
            }

            protected static class Allocation
            extends Throwable {
                private static final long serialVersionUID = 1L;
                public final ConnectionInfo info;

                Allocation(ConnectionInfo info) {
                    super("Allocation stack trace of " + info.toString());
                    this.info = info;
                }
            }

            public static class AllocationErrors
            extends RuntimeException {
                private static final long serialVersionUID = 1L;

                protected AllocationErrors(Context context) {
                    super("leaked " + context.inuse + " connections in " + context.threadName);
                    for (Allocation each : context.inuse.values()) {
                        this.addSuppressed(each);
                        try {
                            each.info.getManagedConnectionInfo().getManagedConnection().destroy();
                        }
                        catch (ResourceException cause) {
                            this.addSuppressed(cause);
                        }
                    }
                }
            }
        }
    }

    public static class TransactionManagerWrapper
    implements RecoverableTransactionManager {
        protected TransactionManager tm;

        public TransactionManagerWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.tm.setTransactionTimeout(seconds);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.tm.resume(tobj);
        }

        public Transaction getTransaction() throws SystemException {
            return this.tm.getTransaction();
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.tm.commit();
        }

        public void begin() throws SystemException {
            try {
                this.tm.begin();
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void registerNamedXAResourceFactory(NamedXAResourceFactory factory) {
            if (RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                ((RecoverableTransactionManager)this.tm).registerNamedXAResourceFactory(factory);
            }
        }

        public void unregisterNamedXAResourceFactory(String factory) {
            if (RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                ((RecoverableTransactionManager)this.tm).unregisterNamedXAResourceFactory(factory);
            }
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }

    public static class UserTransactionImpl
    implements UserTransaction {
        protected final TransactionManager transactionManager;

        public UserTransactionImpl(TransactionManager manager) {
            this.transactionManager = manager;
        }

        public int getStatus() throws SystemException {
            return this.transactionManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.transactionManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            this.transactionManager.begin();
            timers.put(this.transactionManager.getTransaction(), transactionTimer.time());
            concurrentCount.inc();
            if (concurrentCount.getCount() > concurrentMaxCount.getCount()) {
                concurrentMaxCount.inc();
            }
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            Timer.Context timerContext = timers.remove(this.transactionManager.getTransaction());
            this.transactionManager.commit();
            if (timerContext != null) {
                timerContext.stop();
            }
            concurrentCount.dec();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Timer.Context timerContext = timers.remove(this.transactionManager.getTransaction());
            this.transactionManager.rollback();
            concurrentCount.dec();
            if (timerContext != null) {
                timerContext.stop();
            }
            rollbackCount.inc();
        }
    }

    public static class InstallContext
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final String threadName = Thread.currentThread().getName();

        InstallContext() {
            super("Container installation context (" + Thread.currentThread().getName() + ")");
        }
    }
}

