/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import java.util.Collections;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.TransactionManager;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.jtajca.NuxeoContainer;

public class NuxeoTransactionManagerFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(NuxeoTransactionManagerFactory.class);

    @Override
    public Object getObjectInstance(Object obj, Name objName, Context nameCtx, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)obj;
        if (!TransactionManager.class.getName().equals(ref.getClassName())) {
            return null;
        }
        if (NuxeoContainer.transactionManager != null) {
            return NuxeoContainer.transactionManager;
        }
        NuxeoContainer.TransactionManagerConfiguration config = new NuxeoContainer.TransactionManagerConfiguration();
        for (RefAddr addr : Collections.list(ref.getAll())) {
            String name = addr.getType();
            String value = (String)addr.getContent();
            try {
                BeanUtils.setProperty((Object)config, (String)name, (Object)value);
            }
            catch (Exception e) {
                log.error((Object)String.format("NuxeoTransactionManagerFactory cannot set %s = %s", name, value));
            }
        }
        return NuxeoContainer.initTransactionManager(config);
    }
}

