/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.tex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.wikimodel.wem.IWikiPrinter;
import org.wikimodel.wem.PrintTextListener;
import org.wikimodel.wem.ReferenceHandler;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.images.ImageUtil;

public class TexSerializer
extends PrintTextListener {
    private DocumentContext fContext;
    private Stack<DocumentContext> fContextStack = new Stack();

    public TexSerializer(IWikiPrinter printer) {
        super(printer);
    }

    public void beginDocument() {
        if (this.fContext == null) {
            this.println("\\documentclass{article}");
            this.println("\\usepackage{graphics} % for pdf, bitmapped graphics files");
            this.println("\\usepackage{graphicx} % for pdf, bitmapped graphics files");
            this.println("\\usepackage{epsfig} % for postscript graphics files");
            this.println("\\begin{document}");
            this.println();
        }
        this.fContext = new DocumentContext();
        this.fContextStack.push(this.fContext);
    }

    public void beginHeader(int level, WikiParameters params) {
        this.println();
        this.print("\\");
        for (int i = 0; i < level - 1; ++i) {
            this.print("sub");
        }
        this.print("section{");
    }

    public void beginList(WikiParameters parameters, boolean ordered) {
        this.println("\\begin{itemize}");
    }

    public void beginListItem() {
        this.print(" \\item ");
    }

    public void beginParagraph(WikiParameters params) {
        this.println("");
    }

    public void beginTable(WikiParameters params) {
        this.println("\\begin{center}");
        this.println("\\begin{footnotesize}");
        this.println("\\begin{tabular}{|p{6cm}|p{5cm}|}\\hline");
        this.fContext.fTableHead = true;
    }

    public void beginTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "\\textcolor{white}" : "";
        this.print(str + params);
        if (tableHead) {
            this.fContext.fTableHeadCell = true;
        }
        if (!this.fContext.fFirstRowCell) {
            this.print("&");
        }
        this.fContext.fFirstRowCell = false;
    }

    public void beginTableRow(WikiParameters params) {
        if (this.fContext.fTableHead) {
            this.print("\\rowcolor{style@lightblue}");
        } else {
            this.print("");
        }
        this.fContext.fFirstRowCell = true;
    }

    public void endDocument() {
        this.fContextStack.pop();
        DocumentContext documentContext = this.fContext = !this.fContextStack.empty() ? this.fContextStack.peek() : null;
        if (this.fContext == null) {
            this.println("\\end{document}");
        }
    }

    public void endHeader(int level, WikiParameters params) {
        this.println("}");
    }

    public void endList(WikiParameters parameters, boolean ordered) {
        this.println("\\end{itemize}");
    }

    public void endListItem() {
        this.println("");
    }

    public void endParagraph(WikiParameters params) {
        this.println("");
    }

    public void endQuotationLine() {
        this.println("");
    }

    public void endTable(WikiParameters params) {
        this.println("\\end{tabular}");
        this.println("\\end{footnotesize}");
        this.println("\\end{center}");
    }

    public void endTableCell(boolean tableHead, WikiParameters params) {
        if (tableHead) {
            this.print("}");
        }
    }

    public void endTableRow(WikiParameters params) {
        this.println("\\\\\\hline");
        this.fContext.fTableHead = false;
    }

    protected InputStream getImageInput(String ref) throws IOException {
        return null;
    }

    protected int[] getImageSize(String ref) {
        int[] result = null;
        try {
            InputStream input = this.getImageInput(ref);
            if (input != null) {
                int maxWidth = this.getMaxImageWidth();
                int maxHeight = this.getMaxImageHeight();
                return ImageUtil.getImageSize(input, maxWidth, maxHeight);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected int getMaxImageHeight() {
        return 300;
    }

    protected int getMaxImageWidth() {
        return 300;
    }

    protected ReferenceHandler newReferenceHandler() {
        return new ReferenceHandler(){
            Map<String, int[]> fImageSizes = new HashMap<String, int[]>();

            protected void handleImage(String ref, String label) {
                int[] size;
                if (this.fImageSizes.containsKey(ref)) {
                    size = this.fImageSizes.get(ref);
                } else {
                    size = TexSerializer.this.getImageSize(ref);
                    this.fImageSizes.put(ref, size);
                }
                if (size != null) {
                    String dim = "[bb=0 0 " + size[0] + " " + size[1] + "]";
                    TexSerializer.this.println("\\includegraphics" + dim + "{" + WikiPageUtil.escapeXmlString(ref) + "}");
                    ref = ref.replaceAll("_", "-");
                }
            }

            protected void handleReference(String ref, String label) {
                TexSerializer.this.print(label);
                TexSerializer.this.print(" (");
                TexSerializer.this.print(ref);
                TexSerializer.this.print(")");
            }
        };
    }

    public void onEscape(String str) {
        this.print(str);
    }

    public void onLineBreak() {
        this.println("\\newline");
    }

    public void onNewLine() {
        this.println("");
    }

    public void onSpace(String str) {
        this.print(str);
    }

    public void onSpecialSymbol(String str) {
        if (!str.equals("}") && !str.equals("{")) {
            this.print(str);
        }
    }

    public void onWord(String str) {
        if (this.fContext.fTableHeadCell) {
            this.print("{\\bf ");
            this.fContext.fTableHeadCell = false;
        }
        this.print(str);
    }

    private static class DocumentContext {
        boolean fFirstRowCell = false;
        boolean fTableHead = false;
        boolean fTableHeadCell = false;

        private DocumentContext() {
        }
    }
}

