/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.listeners;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.impl.service.PublisherServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class DomainEventsListener
implements EventListener {
    public static final String DISABLE_DOMAIN_LISTENER = "disableDomainListener";

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx;
        DocumentModel doc;
        EventContext ctx = event.getContext();
        Boolean disableListener = (Boolean)ctx.getProperty(DISABLE_DOMAIN_LISTENER);
        if (Boolean.TRUE.equals(disableListener)) {
            return;
        }
        if (ctx instanceof DocumentEventContext && (doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()) != null && "Domain".equals(doc.getType())) {
            String eventName = event.getName();
            if ("documentCreated".equals(eventName)) {
                this.registerNewPublicationTrees(doc);
            } else if ("documentModified".equals(eventName)) {
                this.unregisterPublicationTrees(doc);
                this.registerNewPublicationTrees(doc);
            } else if ("documentRemoved".equals(eventName)) {
                this.unregisterPublicationTrees(doc);
            } else if ("lifecycle_transition_event".equals(eventName)) {
                this.handleDomainLifeCycleChanged(docCtx, doc);
            }
        }
    }

    protected void registerNewPublicationTrees(DocumentModel doc) throws ClientException {
        try {
            PublisherServiceImpl service = (PublisherServiceImpl)((Object)Framework.getService(PublisherService.class));
            service.registerTreeConfigFor(doc);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void unregisterPublicationTrees(DocumentModel doc) throws ClientException {
        try {
            PublisherServiceImpl service = (PublisherServiceImpl)((Object)Framework.getService(PublisherService.class));
            service.unRegisterTreeConfigFor(doc);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected void handleDomainLifeCycleChanged(DocumentEventContext docCtx, DocumentModel doc) throws ClientException {
        String from = (String)((Object)docCtx.getProperty("from"));
        String to = (String)((Object)docCtx.getProperty("to"));
        if ("deleted".equals(to)) {
            this.handleDomainGoesToDeletedState(doc);
        } else if ("deleted".equals(from)) {
            this.handleDomainGoesFromDeletedState(doc);
        }
    }

    protected void handleDomainGoesToDeletedState(DocumentModel doc) throws ClientException {
        this.unregisterPublicationTrees(doc);
    }

    protected void handleDomainGoesFromDeletedState(DocumentModel doc) throws ClientException {
        this.registerNewPublicationTrees(doc);
    }
}

