/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.service;

import java.util.List;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutManager;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public abstract class AbstractLayoutManager
extends DefaultComponent
implements LayoutManager {
    private static final long serialVersionUID = 1L;

    public abstract String getDefaultStoreCategory();

    protected LayoutStore getLayoutStore() {
        LayoutStore lm = null;
        try {
            lm = (LayoutStore)Framework.getLocalService(LayoutStore.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (lm == null) {
            throw new RuntimeException("Missing service for LayoutStore");
        }
        return lm;
    }

    public WidgetType getWidgetType(String typeName) {
        return this.getLayoutStore().getWidgetType(this.getDefaultStoreCategory(), typeName);
    }

    public WidgetTypeDefinition getWidgetTypeDefinition(String typeName) {
        return this.getLayoutStore().getWidgetTypeDefinition(this.getDefaultStoreCategory(), typeName);
    }

    public List<WidgetTypeDefinition> getWidgetTypeDefinitions() {
        return this.getLayoutStore().getWidgetTypeDefinitions(this.getDefaultStoreCategory());
    }

    public LayoutDefinition getLayoutDefinition(String layoutName) {
        return this.getLayoutStore().getLayoutDefinition(this.getDefaultStoreCategory(), layoutName);
    }

    public List<String> getLayoutDefinitionNames() {
        return this.getLayoutStore().getLayoutDefinitionNames(this.getDefaultStoreCategory());
    }

    public WidgetDefinition getWidgetDefinition(String widgetName) {
        return this.getLayoutStore().getWidgetDefinition(this.getDefaultStoreCategory(), widgetName);
    }

    protected void registerWidgetType(WidgetTypeDefinition desc) {
        this.getLayoutStore().registerWidgetType(this.getDefaultStoreCategory(), desc);
    }

    protected void unregisterWidgetType(WidgetTypeDefinition desc) {
        this.getLayoutStore().unregisterWidgetType(this.getDefaultStoreCategory(), desc);
    }

    protected void registerLayout(LayoutDefinition layoutDef) {
        this.getLayoutStore().registerLayout(this.getDefaultStoreCategory(), layoutDef);
    }

    protected void unregisterLayout(LayoutDefinition layoutDef) {
        this.getLayoutStore().unregisterLayout(this.getDefaultStoreCategory(), layoutDef);
    }

    protected void registerWidget(WidgetDefinition widgetDef) {
        this.getLayoutStore().registerWidget(this.getDefaultStoreCategory(), widgetDef);
    }

    protected void unregisterWidget(WidgetDefinition widgetDef) {
        this.getLayoutStore().unregisterWidget(this.getDefaultStoreCategory(), widgetDef);
    }
}

