/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.cookies;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisHttpCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisCookieStoreImpl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String IP_ADDRESS_PATTERN_STR = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private final int maxUrls;
    private final LinkedList<CmisHttpCookie> storeList;

    public CmisCookieStoreImpl() {
        this(300);
    }

    public CmisCookieStoreImpl(int maxUrls) {
        this.maxUrls = maxUrls;
        this.storeList = new LinkedList();
    }

    public void add(URI uri, CmisHttpCookie cookie) {
        if (uri == null || cookie == null) {
            throw new IllegalArgumentException("URI and cookie must be set!");
        }
        if (cookie.hasExpired()) {
            this.storeList.remove(cookie);
            return;
        }
        Iterator iter = this.storeList.iterator();
        while (iter.hasNext()) {
            CmisHttpCookie storeCookie = (CmisHttpCookie)iter.next();
            if (!storeCookie.equals(cookie) && !storeCookie.hasExpired()) continue;
            iter.remove();
        }
        this.storeList.addFirst(cookie);
        if (this.storeList.size() > this.maxUrls) {
            this.storeList.removeLast();
        }
    }

    public List<CmisHttpCookie> get(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null!");
        }
        String uriHost = uri.getHost().toLowerCase();
        boolean isSecure = false;
        String scheme = uri.getScheme();
        if (scheme != null) {
            isSecure = scheme.toLowerCase(Locale.ENGLISH).startsWith("https");
        }
        ArrayList<CmisHttpCookie> cookies = new ArrayList<CmisHttpCookie>();
        Iterator iter = this.storeList.iterator();
        while (iter.hasNext()) {
            CmisHttpCookie cookie = (CmisHttpCookie)iter.next();
            if (cookie.hasExpired()) {
                iter.remove();
                continue;
            }
            if (cookie.getSecure() && !isSecure || cookie.getDomain() == null) continue;
            String cookieDomain = cookie.getDomain().toLowerCase();
            if (this.isIPAddress(uriHost) && uriHost.equals(cookieDomain)) {
                cookies.add(cookie);
                continue;
            }
            if (cookie.getVersion() == 0) {
                if (!uriHost.endsWith(cookieDomain) || uriHost.length() != cookieDomain.length() && cookieDomain.charAt(0) != '.') continue;
                cookies.add(cookie);
                continue;
            }
            if (cookie.getVersion() != 1 || !CmisHttpCookie.domainMatches(cookieDomain, uriHost)) continue;
            cookies.add(cookie);
        }
        return cookies;
    }

    private boolean isIPAddress(String s) {
        if (s.charAt(0) == '[') {
            return true;
        }
        return IP_ADDRESS_PATTERN.matcher(s).matches();
    }
}

