/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType4;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Type4ShadingContext
extends GouraudShadingContext {
    private static final Log LOG = LogFactory.getLog(Type4ShadingContext.class);
    private int bitsPerFlag;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Type4ShadingContext(PDShadingType4 shadingType4, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) throws IOException {
        super(shadingType4, colorModelValue, xform, ctm, pageHeight);
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        LOG.debug((Object)"Type4ShadingContext");
        this.bitsPerColorComponent = shadingType4.getBitsPerComponent();
        LOG.debug((Object)("bitsPerColorComponent: " + this.bitsPerColorComponent));
        this.bitsPerCoordinate = shadingType4.getBitsPerCoordinate();
        LOG.debug((Object)(Math.pow(2.0, this.bitsPerCoordinate) - 1.0));
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        LOG.debug((Object)("maxSrcCoord: " + maxSrcCoord));
        LOG.debug((Object)("maxSrcColor: " + maxSrcColor));
        COSDictionary cosDictionary = shadingType4.getCOSDictionary();
        COSStream cosStream = (COSStream)cosDictionary;
        COSArray decode = (COSArray)cosDictionary.getDictionaryObject(COSName.DECODE);
        LOG.debug((Object)("decode: " + decode));
        PDRange rangeX = shadingType4.getDecodeForParameter(0);
        PDRange rangeY = shadingType4.getDecodeForParameter(1);
        LOG.debug((Object)("rangeX: " + rangeX.getMin() + ", " + rangeX.getMax()));
        LOG.debug((Object)("rangeY: " + rangeY.getMin() + ", " + rangeY.getMax()));
        PDRange[] colRangeTab = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRangeTab[i] = shadingType4.getDecodeForParameter(2 + i);
        }
        LOG.debug((Object)("bitsPerCoordinate: " + this.bitsPerCoordinate));
        this.bitsPerFlag = shadingType4.getBitsPerFlag();
        LOG.debug((Object)("bitsPerFlag: " + this.bitsPerFlag));
        LOG.debug((Object)("Stream size: " + cosStream.getInt(COSName.LENGTH)));
        COSArray bg = shadingType4.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
        }
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());
        try {
            block7: while (true) {
                byte flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                LOG.debug((Object)("flag: " + flag));
                switch (flag) {
                    case 0: {
                        Vertex v1 = this.readVertex(mciis, flag, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRangeTab);
                        Vertex v2 = this.readVertex(mciis, (byte)mciis.readBits(this.bitsPerFlag), maxSrcCoord, maxSrcColor, rangeX, rangeY, colRangeTab);
                        Vertex v3 = this.readVertex(mciis, (byte)mciis.readBits(this.bitsPerFlag), maxSrcCoord, maxSrcColor, rangeX, rangeY, colRangeTab);
                        vertexList.add(v1);
                        vertexList.add(v2);
                        vertexList.add(v3);
                        continue block7;
                    }
                    case 1: 
                    case 2: {
                        vertexList.add(this.readVertex(mciis, flag, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRangeTab));
                        continue block7;
                    }
                }
                LOG.warn((Object)("bad flag: " + flag));
            }
        }
        catch (EOFException ex) {
            LOG.debug((Object)"EOF");
            if (vertexList.size() < 3) {
                LOG.warn((Object)"Incomplete mesh is ignored");
                vertexList.clear();
            } else if (vertexList.size() > 1 && ((Vertex)vertexList.get((int)0)).flag != 0) {
                LOG.warn((Object)("Mesh with incorrect start flag " + ((Vertex)vertexList.get((int)0)).flag + " is ignored"));
                vertexList.clear();
            }
            int vi = 0;
            while (vi < vertexList.size()) {
                if (((Vertex)vertexList.get((int)vi)).flag == 0) {
                    if (vi + 2 >= vertexList.size()) {
                        LOG.warn((Object)"Mesh with incomplete triangle");
                        while (vertexList.size() >= vi + 1) {
                            vertexList.remove(vi);
                        }
                        break;
                    } else {
                        vi += 3;
                        continue;
                    }
                }
                ++vi;
            }
            mciis.close();
            this.transformVertices(vertexList, ctm, xform, pageHeight);
            this.createTriangleList(vertexList);
            return;
        }
    }

    private void createTriangleList(ArrayList<Vertex> vertexList) {
        Point2D a = null;
        Point2D b = null;
        Point2D c = null;
        float[] aColor = null;
        float[] bColor = null;
        float[] cColor = null;
        for (int vi = 0; vi < vertexList.size(); ++vi) {
            Vertex v = vertexList.get(vi);
            switch (v.flag) {
                case 0: {
                    a = v.point;
                    aColor = v.color;
                    v = vertexList.get(++vi);
                    b = v.point;
                    bColor = v.color;
                    v = vertexList.get(++vi);
                    c = v.point;
                    cColor = v.color;
                    break;
                }
                case 1: {
                    a = b;
                    aColor = bColor;
                    b = c;
                    bColor = cColor;
                    v = vertexList.get(vi);
                    c = v.point;
                    cColor = v.color;
                    break;
                }
                case 2: {
                    b = c;
                    bColor = cColor;
                    v = vertexList.get(vi);
                    c = v.point;
                    cColor = v.color;
                    break;
                }
            }
            GouraudTriangle g = new GouraudTriangle(a, aColor, b, bColor, c, cColor);
            if (!g.isEmpty()) {
                this.triangleList.add(g);
                continue;
            }
            LOG.debug((Object)"triangle is empty!");
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

