/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css;

import com.phloc.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSFilenameHelper {
    private CSSFilenameHelper() {
    }

    public static boolean isCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((CharSequence)string, (CharSequence)".css");
    }

    public static boolean isMinifiedCSSFilename(@Nullable String string) {
        return StringHelper.endsWith((CharSequence)string, (CharSequence)".min.css");
    }

    public static boolean isRegularCSSFilename(@Nullable String string) {
        return CSSFilenameHelper.isCSSFilename(string) && !CSSFilenameHelper.isMinifiedCSSFilename(string);
    }

    @Nonnull
    public static String getMinifiedCSSFilename(@Nonnull String string) {
        if (!CSSFilenameHelper.isCSSFilename(string)) {
            throw new IllegalArgumentException("Passed file name '" + string + "' is not a CSS file name!");
        }
        if (CSSFilenameHelper.isMinifiedCSSFilename(string)) {
            return string;
        }
        return StringHelper.trimEnd((String)string, (String)".css") + ".min.css";
    }
}

