/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSUnit;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.ICSSExpressionMathMember;
import com.phloc.css.utils.CSSNumberHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSExpressionMemberMathUnitSimple
implements ICSSExpressionMathMember {
    private final String m_sText;
    private final ECSSUnit m_eUnit;

    public CSSExpressionMemberMathUnitSimple(@Nonnull @Nonempty String string) {
        if (StringHelper.hasNoTextAfterTrim((String)string)) {
            throw new IllegalArgumentException("text");
        }
        this.m_sText = string.trim();
        this.m_eUnit = CSSNumberHelper.getMatchingUnitExclPercentage(this.m_sText);
    }

    @Nonnull
    public String getText() {
        return this.m_sText;
    }

    @Nullable
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.m_sText;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSExpressionMemberMathUnitSimple)) {
            return false;
        }
        CSSExpressionMemberMathUnitSimple cSSExpressionMemberMathUnitSimple = (CSSExpressionMemberMathUnitSimple)object;
        return this.m_sText.equals(cSSExpressionMemberMathUnitSimple.m_sText);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("text", (Object)this.m_sText).append("unit", (Enum)this.m_eUnit).toString();
    }
}

