/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSKeyframesBlock
implements IHasCSSDeclarations,
ICSSVersionAware {
    private final List<String> m_aKeyframesSelectors;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();

    public CSSKeyframesBlock(@Nonnull @Nonempty List<String> list) {
        if (ContainerHelper.isEmpty(list)) {
            throw new IllegalArgumentException("keyframesSelectors");
        }
        if (ContainerHelper.containsAnyNullElement(list)) {
            throw new IllegalArgumentException("keyframesSelectors contains at least one null element");
        }
        this.m_aKeyframesSelectors = ContainerHelper.newList(list);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<String> getAllKeyframesSelectors() {
        return ContainerHelper.newList(this.m_aKeyframesSelectors);
    }

    @Override
    public void addDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        this.m_aDeclarations.addDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration cSSDeclaration) {
        return this.m_aDeclarations.removeDeclaration(cSSDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int n) {
        return this.m_aDeclarations.removeDeclaration(n);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int n) {
        return this.m_aDeclarations.getDeclarationAtIndex(n);
    }

    @Override
    public boolean hasDeclarations() {
        return this.m_aDeclarations.hasDeclarations();
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.getDeclarationCount() == 0) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.m_aKeyframesSelectors) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(string);
        }
        stringBuilder.append(this.m_aDeclarations.getAsCSSString(iCSSWriterSettings, n));
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSKeyframesBlock)) {
            return false;
        }
        CSSKeyframesBlock cSSKeyframesBlock = (CSSKeyframesBlock)object;
        return ((Object)this.m_aKeyframesSelectors).equals(cSSKeyframesBlock.m_aKeyframesSelectors) && this.m_aDeclarations.equals(cSSKeyframesBlock.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aKeyframesSelectors).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("keyframesSelectors", this.m_aKeyframesSelectors).append("declarations", (Object)this.m_aDeclarations).toString();
    }
}

