/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.parser;

import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.parser.Node;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CSSNode
implements Node,
Iterable<CSSNode> {
    private final int m_nType;
    private CSSNode m_aParent;
    private CSSNode[] m_aChildren;
    private Object m_aValue;
    private String m_sText;

    public CSSNode(int n) {
        this.m_nType = n;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(@Nullable Node node) {
        this.m_aParent = (CSSNode)node;
    }

    @Override
    @Nullable
    public Node jjtGetParent() {
        return this.m_aParent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.m_aChildren == null) {
            this.m_aChildren = new CSSNode[n + 1];
        } else if (n >= this.m_aChildren.length) {
            CSSNode[] cSSNodeArray = new CSSNode[n + 1];
            System.arraycopy(this.m_aChildren, 0, cSSNodeArray, 0, this.m_aChildren.length);
            this.m_aChildren = cSSNodeArray;
        }
        this.m_aChildren[n] = (CSSNode)node;
    }

    @Override
    public CSSNode jjtGetChild(int n) {
        return this.m_aChildren[n];
    }

    @Override
    @Nonnegative
    public int jjtGetNumChildren() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.length;
    }

    public void setValue(@Nullable Object object) {
        this.m_aValue = object;
    }

    @Nullable
    public Object getValue() {
        return this.m_aValue;
    }

    public void setText(@Nullable String string) {
        this.m_sText = string;
    }

    public void appendText(String string) {
        this.m_sText = this.m_sText == null ? string : this.m_sText + string;
    }

    @Nullable
    public String getText() {
        return this.m_sText;
    }

    public boolean hasText() {
        return this.m_sText != null;
    }

    public int getNodeType() {
        return this.m_nType;
    }

    @Override
    @Nonnull
    public Iterator<CSSNode> iterator() {
        ArrayList<CSSNode> arrayList = new ArrayList<CSSNode>(this.jjtGetNumChildren());
        if (this.m_aChildren != null) {
            for (CSSNode cSSNode : this.m_aChildren) {
                if (cSSNode == null) continue;
                arrayList.add(cSSNode);
            }
        }
        return arrayList.iterator();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("type", this.m_nType).appendIfNotNull("parentType", this.m_aParent == null ? null : Integer.valueOf(this.m_aParent.m_nType)).appendIfNotNull("value", this.m_aValue).appendIfNotNull("text", (Object)this.m_sText).appendIfNotNull("children", (Object[])this.m_aChildren).toString();
    }
}

