/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSSimpleValueWithUnit {
    private final double m_dValue;
    private final ECSSUnit m_eUnit;

    public CSSSimpleValueWithUnit(double d, @Nonnull ECSSUnit eCSSUnit) {
        if (eCSSUnit == null) {
            throw new NullPointerException("unit");
        }
        this.m_dValue = d;
        this.m_eUnit = eCSSUnit;
    }

    public double getValue() {
        return this.m_dValue;
    }

    public int getAsIntValue() {
        return (int)this.m_dValue;
    }

    public long getAsLongValue() {
        return (long)this.m_dValue;
    }

    @Nonnull
    public ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSSimpleValueWithUnit)) {
            return false;
        }
        CSSSimpleValueWithUnit cSSSimpleValueWithUnit = (CSSSimpleValueWithUnit)object;
        return EqualsUtils.equals((double)this.m_dValue, (double)cSSSimpleValueWithUnit.m_dValue) && this.m_eUnit.equals(cSSSimpleValueWithUnit.m_eUnit);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_dValue).append((Enum)this.m_eUnit).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("value", this.m_dValue).append("unit", (Enum)this.m_eUnit).toString();
    }
}

