/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.propertyvalue;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.property.ECSSProperty;
import com.phloc.css.property.ICSSProperty;
import com.phloc.css.propertyvalue.CSSValue;
import com.phloc.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CSSValueMultiValue
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues = new ArrayList<CSSValue>();

    public CSSValueMultiValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull @Nonempty String[] stringArray, boolean bl) {
        if (iCSSProperty == null) {
            throw new NullPointerException("property");
        }
        if (ArrayHelper.isEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("No value passed!");
        }
        for (String string : stringArray) {
            this.m_aValues.add(new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getContainedValues() {
        return ContainerHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        if (this.m_aValues.isEmpty()) {
            throw new IllegalStateException("no value present to determine the property from!");
        }
        return ((CSSValue)ContainerHelper.getFirstElement(this.m_aValues)).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSValue cSSValue : this.m_aValues) {
            stringBuilder.append(cSSValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CSSValueMultiValue)) {
            return false;
        }
        CSSValueMultiValue cSSValueMultiValue = (CSSValueMultiValue)object;
        return ((Object)this.m_aValues).equals(cSSValueMultiValue.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

