/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.reader;

import com.phloc.commons.charset.CCharset;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.resource.FileSystemResource;
import com.phloc.commons.io.streamprovider.StringInputStreamProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.handler.CSSHandler;
import com.phloc.css.handler.DoNothingCSSParseExceptionHandler;
import com.phloc.css.handler.ICSSParseExceptionHandler;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.CharStream;
import com.phloc.css.parser.JavaCharStream;
import com.phloc.css.parser.ParseException;
import com.phloc.css.parser.ParseUtils;
import com.phloc.css.parser.ParserCSS21;
import com.phloc.css.parser.ParserCSS21TokenManager;
import com.phloc.css.parser.ParserCSS30;
import com.phloc.css.parser.ParserCSS30TokenManager;
import com.phloc.css.parser.ParserCSSCharsetDetector;
import com.phloc.css.parser.ParserCSSCharsetDetectorTokenManager;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReader {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReader.class);

    private CSSReader() {
    }

    @Nullable
    private static CSSNode _readStyleSheet(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        switch (eCSSVersion) {
            case CSS21: {
                ParserCSS21TokenManager parserCSS21TokenManager = new ParserCSS21TokenManager(charStream);
                ParserCSS21 parserCSS21 = new ParserCSS21(parserCSS21TokenManager);
                try {
                    return parserCSS21.styleSheet();
                }
                catch (ParseException parseException) {
                    if (iCSSParseExceptionHandler != null) {
                        iCSSParseExceptionHandler.onException(parseException);
                    } else {
                        s_aLogger.error("Failed to parse CSS 2.1 style sheet: " + parseException.getMessage());
                    }
                    return null;
                }
            }
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                try {
                    return parserCSS30.styleSheet();
                }
                catch (ParseException parseException) {
                    if (iCSSParseExceptionHandler != null) {
                        iCSSParseExceptionHandler.onException(parseException);
                    } else {
                        s_aLogger.error("Failed to parse CSS 3.0 style sheet: " + parseException.getMessage());
                    }
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), string, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReader.isValidCSS(iReadableResource, charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        if (iReadableResource == null) {
            throw new NullPointerException("resources");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReader.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (string == null) {
            throw new NullPointerException("charset");
        }
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (String)string), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        return CSSReader.isValidCSS(StreamUtils.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        if (string == null) {
            throw new NullPointerException("reader");
        }
        return CSSReader.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        try {
            JavaCharStream javaCharStream = new JavaCharStream(reader);
            CSSNode cSSNode = CSSReader._readStyleSheet(javaCharStream, eCSSVersion, new DoNothingCSSParseExceptionHandler());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamUtils.close((Closeable)reader);
        }
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromString(string, string2, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromString(string, charset, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull String string2, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(string, string2), string2, eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromString(@Nonnull String string, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new StringInputStreamProvider(string, charset), charset, eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, string, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromFile(file, charset, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(file), string, eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        return CSSReader.readFromStream((IInputStreamProvider)new FileSystemResource(file), charset, eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iInputStreamProvider, string, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReader.readFromStream(iInputStreamProvider, charset, eCSSVersion, null);
    }

    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        Charset charset = CharsetManager.getCharsetFromName((String)string);
        return CSSReader.readFromStream(iInputStreamProvider, charset, eCSSVersion, iCSSParseExceptionHandler);
    }

    @Nullable
    public static Charset getCharsetDeclaredInCSS(@Nonnull IInputStreamProvider iInputStreamProvider) {
        if (iInputStreamProvider == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        InputStream inputStream = iInputStreamProvider.getInputStream();
        if (inputStream == null) {
            return null;
        }
        try {
            JavaCharStream javaCharStream = new JavaCharStream(inputStream, CCharset.CHARSET_ISO_8859_1_OBJ);
            ParserCSSCharsetDetectorTokenManager parserCSSCharsetDetectorTokenManager = new ParserCSSCharsetDetectorTokenManager(javaCharStream);
            ParserCSSCharsetDetector parserCSSCharsetDetector = new ParserCSSCharsetDetector(parserCSSCharsetDetectorTokenManager);
            String string = parserCSSCharsetDetector.styleSheetCharset().getText();
            if (string == null) {
                Charset charset = null;
                return charset;
            }
            Charset charset = CharsetManager.getCharsetFromName((String)ParseUtils.extractStringValue(string));
            return charset;
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("Failed to parse CSS charset definition", parseException);
        }
        finally {
            StreamUtils.close((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CascadingStyleSheet readFromStream(@Nonnull IInputStreamProvider iInputStreamProvider, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionHandler iCSSParseExceptionHandler) {
        InputStream inputStream;
        if (iInputStreamProvider == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        if (eCSSVersion == null) {
            throw new NullPointerException("version");
        }
        Charset charset2 = charset;
        Charset charset3 = CSSReader.getCharsetDeclaredInCSS(iInputStreamProvider);
        if (charset3 != null) {
            s_aLogger.info("Reading CSS definition again with explicit charset '" + charset3.name() + "'");
            charset2 = charset3;
        }
        if ((inputStream = iInputStreamProvider.getInputStream()) == null) {
            return null;
        }
        try {
            JavaCharStream javaCharStream = new JavaCharStream(inputStream, charset2);
            CSSNode cSSNode = CSSReader._readStyleSheet(javaCharStream, eCSSVersion, iCSSParseExceptionHandler);
            if (cSSNode == null) {
                CascadingStyleSheet cascadingStyleSheet = null;
                return cascadingStyleSheet;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, cSSNode);
            return cascadingStyleSheet;
        }
        finally {
            StreamUtils.close((Closeable)inputStream);
        }
    }
}

