/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.jaxrs.io.audit.LogEntryList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.AuditPageProvider;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Audit.PageProvider", category="Fetch", label="AuditPageProvider", description="Perform a query or a named provider query against Audit logs. Result is paginated. The query result will become the input for the next operation. If no query or provider name is given, a query based on default Audit page provider will be executed.", addToStudio=false)
public class AuditPageProviderOperation {
    public static final String ID = "Audit.PageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    private static final String SORT_PARAMETER_SEPARATOR = " ";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService ppService;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    @Deprecated
    protected Integer page;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;
    @Param(name="namedQueryParams", required=false)
    protected Properties namedQueryParams;
    @Param(name="maxResults", required=false)
    protected Integer maxResults = 100;

    @OperationMethod
    public Paginable<LogEntry> run() throws Exception {
        PageProviderService pps = (PageProviderService)Framework.getLocalService(PageProviderService.class);
        ArrayList<SortInfo> sortInfos = null;
        if (this.sortInfoAsStringList != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(SORT_PARAMETER_SEPARATOR)) {
                    String[] parts = sortInfoDesc.split(SORT_PARAMETER_SEPARATOR);
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        if (parameters == null) {
            parameters = new Object[]{};
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && (this.providerName == null || this.providerName.length() == 0)) {
            this.providerName = "AUDIT_BROWSER";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        if (this.currentPageIndex != null) {
            targetPage = this.currentPageIndex.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        if (this.query != null) {
            AuditPageProvider app = new AuditPageProvider();
            app.setProperties(props);
            if (this.maxResults != null && !this.maxResults.equals("-1")) {
                app.getProperties().put("maxResults", this.maxResults);
                app.setMaxPageSize((long)this.maxResults.intValue());
            }
            GenericPageProviderDescriptor desc = new GenericPageProviderDescriptor();
            desc.setPattern(this.query);
            app.setParameters(parameters);
            app.setDefinition((PageProviderDefinition)desc);
            app.setSortInfos(sortInfos);
            app.setPageSize(targetPageSize.longValue());
            app.setCurrentPage(targetPage.longValue());
            return new LogEntryList((PageProvider)app);
        }
        DocumentModel searchDoc = null;
        if (this.namedQueryParams != null && this.namedQueryParams.size() > 0) {
            String docType = pps.getPageProviderDefinition(this.providerName).getWhereClause().getDocType();
            searchDoc = this.session.createDocumentModel(docType);
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)searchDoc, (Properties)this.namedQueryParams);
        }
        PageProvider pp = pps.getPageProvider(this.providerName, searchDoc, sortInfos, targetPageSize, targetPage, props, parameters);
        return new LogEntryList(pp);
    }
}

