/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datascroller;

import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.HtmlPanelGroup;
import org.apache.myfaces.custom.datascroller.ScrollerActionEvent;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class HtmlDataScroller
extends HtmlPanelGroup
implements ActionSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScroller.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller));
    private static final String FIRST_FACET_NAME = "first";
    private static final String LAST_FACET_NAME = "last";
    private static final String NEXT_FACET_NAME = "next";
    private static final String PREVIOUS_FACET_NAME = "previous";
    private static final String FAST_FORWARD_FACET_NAME = "fastforward";
    private static final String FAST_REWIND_FACET_NAME = "fastrewind";
    private static final String TABLE_LAYOUT = "table";
    private static final String LIST_LAYOUT = "list";
    private static final String SINGLE_LIST_LAYOUT = "singleList";
    private static final String SINGLE_TABLE_LAYOUT = "singleTable";
    private transient UIData _UIData;
    private transient Boolean _listLayout;
    private transient Boolean _singleElementLayout;
    private MethodBinding _actionListener;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlDataScroller";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.DataScroller";
    private static final boolean DEFAULT_IMMEDIATE = false;
    private String _for = null;
    private Integer _fastStep = null;
    private String _pageIndexVar = null;
    private String _pageCountVar = null;
    private String _rowsCountVar = null;
    private String _displayedRowsCountVar = null;
    private String _firstRowIndexVar = null;
    private String _lastRowIndexVar = null;
    private String _style = null;
    private String _styleClass = null;
    private String _columnClasses = null;
    private Boolean _paginator = null;
    private Integer _paginatorMaxPages = null;
    private String _paginatorTableClass = null;
    private String _paginatorTableStyle = null;
    private String _paginatorColumnClass = null;
    private String _paginatorColumnStyle = null;
    private String _paginatorActiveColumnClass = null;
    private String _paginatorActiveColumnStyle = null;
    private Boolean _paginatorRenderLinkForActive = null;
    private Boolean _renderFacetsIfSinglePage = null;
    private Boolean _immediate;
    private String _onclick;
    private String _ondblclick;
    private String _firstStyleClass;
    private String _lastStyleClass;
    private String _previousStyleClass;
    private String _nextStyleClass;
    private String _fastfStyleClass;
    private String _fastrStyleClass;
    public static final String FACET_FIRST = "first".intern();
    public static final String FACET_PREVIOUS = "previous".intern();
    public static final String FACET_NEXT = "next".intern();
    public static final String FACET_LAST = "last".intern();
    public static final String FACET_FAST_FORWARD = "fastf".intern();
    public static final String FACET_FAST_REWIND = "fastr".intern();
    static /* synthetic */ Class class$org$apache$myfaces$custom$datascroller$HtmlDataScroller;
    static /* synthetic */ Class class$javax$faces$component$UIData;
    static /* synthetic */ Class class$javax$faces$event$ActionListener;

    public boolean isListLayout() {
        if (this._listLayout == null) {
            String layout = this.getLayout();
            if (layout == null || layout.equals(TABLE_LAYOUT) || layout.equals(SINGLE_TABLE_LAYOUT)) {
                this._listLayout = Boolean.FALSE;
            } else if (layout.equals(LIST_LAYOUT) || layout.equals(SINGLE_LIST_LAYOUT)) {
                this._listLayout = Boolean.TRUE;
            } else {
                log.error((Object)("Invalid layout-parameter : " + layout + " provided. Defaulting to table-layout."));
                this._listLayout = Boolean.FALSE;
            }
        }
        return this._listLayout;
    }

    public boolean isSingleElementLayout() {
        if (this._singleElementLayout == null) {
            String layout = this.getLayout();
            this._singleElementLayout = layout == null || layout.equals(SINGLE_LIST_LAYOUT) || layout.equals(SINGLE_TABLE_LAYOUT) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._singleElementLayout;
    }

    public void queueEvent(FacesEvent event) {
        if (event != null && event instanceof ActionEvent) {
            if (this.isImmediate()) {
                event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
        }
        super.queueEvent(event);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ScrollerActionEvent) {
            ScrollerActionEvent scrollerEvent = (ScrollerActionEvent)event;
            this.broadcastToActionListener(scrollerEvent);
            UIData uiData = this.getUIData();
            if (uiData == null) {
                return;
            }
            int pageindex = scrollerEvent.getPageIndex();
            if (pageindex == -1) {
                String facet = scrollerEvent.getScrollerfacet();
                if (FACET_FIRST.equals(facet)) {
                    this.setFirst(uiData, 0);
                } else if (FACET_PREVIOUS.equals(facet)) {
                    int previous = uiData.getFirst() - uiData.getRows();
                    if (previous >= 0) {
                        this.setFirst(uiData, previous);
                    }
                } else if (FACET_NEXT.equals(facet)) {
                    int next = uiData.getFirst() + uiData.getRows();
                    if (next < uiData.getRowCount()) {
                        this.setFirst(uiData, next);
                    }
                } else if (FACET_FAST_FORWARD.equals(facet)) {
                    int rowcount;
                    int next;
                    int fastStep = this.getFastStep();
                    if (fastStep <= 0) {
                        fastStep = 1;
                    }
                    if ((next = uiData.getFirst() + uiData.getRows() * fastStep) > (rowcount = uiData.getRowCount())) {
                        next = rowcount - 1 - (rowcount - 1) % uiData.getRows();
                    }
                    this.setFirst(uiData, next);
                } else if (FACET_FAST_REWIND.equals(facet)) {
                    int previous;
                    int fastStep = this.getFastStep();
                    if (fastStep <= 0) {
                        fastStep = 1;
                    }
                    if ((previous = uiData.getFirst() - uiData.getRows() * fastStep) < 0) {
                        previous = 0;
                    }
                    this.setFirst(uiData, previous);
                } else if (FACET_LAST.equals(facet)) {
                    int first;
                    int rows;
                    int rowcount = uiData.getRowCount();
                    int delta = rowcount % (rows = uiData.getRows());
                    int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
                    if (first >= 0) {
                        this.setFirst(uiData, first);
                    } else {
                        this.setFirst(uiData, 0);
                    }
                }
            } else {
                int pageCount = this.getPageCount();
                if (pageindex > pageCount) {
                    pageindex = pageCount;
                } else if (pageindex <= 0) {
                    pageindex = 1;
                }
                this.setFirst(uiData, uiData.getRows() * (pageindex - 1));
            }
        }
    }

    protected void setFirst(UIData uiData, int value) {
        if (uiData.getValueBinding(FIRST_FACET_NAME) != null) {
            ValueBinding vb = uiData.getValueBinding(FIRST_FACET_NAME);
            vb.setValue(this.getFacesContext(), (Object)new Integer(value));
        } else {
            uiData.setFirst(value);
        }
    }

    protected void broadcastToActionListener(ScrollerActionEvent event) {
        ActionListener defaultActionListener;
        FacesContext context = this.getFacesContext();
        MethodBinding actionListenerBinding = this.getActionListener();
        if (actionListenerBinding != null) {
            try {
                actionListenerBinding.invoke(context, new Object[]{event});
            }
            catch (EvaluationException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof AbortProcessingException) {
                    throw (AbortProcessingException)cause;
                }
                throw e;
            }
        }
        if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
            defaultActionListener.processAction((ActionEvent)event);
        }
    }

    public UIData getUIData() {
        if (this._UIData == null) {
            this._UIData = this.findUIData();
        }
        return this._UIData;
    }

    public int getPageIndex() {
        int pageIndex;
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        if (0 == rows) {
            throw new FacesException("You need to set a value to the 'rows' attribute of component '" + uiData.getClientId(this.getFacesContext()) + "'");
        }
        if (rows > 0) {
            pageIndex = uiData.getFirst() / rows + 1;
        } else {
            log.warn((Object)("DataTable " + uiData.getClientId(FacesContext.getCurrentInstance()) + " has invalid rows attribute."));
            pageIndex = 0;
        }
        if (uiData.getFirst() % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    public int getPageCount() {
        int pageCount;
        UIData uiData = this.getUIData();
        int rows = uiData.getRows();
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : uiData.getRowCount() / rows;
            if (uiData.getRowCount() % rows > 0) {
                ++pageCount;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getRowCount() {
        return this.getUIData().getRowCount();
    }

    public int getRows() {
        return this.getUIData().getRows();
    }

    public int getFirstRow() {
        return this.getUIData().getFirst();
    }

    protected UIData findUIData() {
        String forStr = this.getFor();
        UIComponent forComp = forStr == null ? this.getParent() : this.findComponent(forStr);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find UIData referenced by attribute dataScroller@for = '" + forStr + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute dataScroller@for = '" + forStr + "' must be of type " + (class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlDataScroller.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData).getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public void setFirst(UIComponent first) {
        this.getFacets().put(FIRST_FACET_NAME, first);
    }

    public UIComponent getFirst() {
        return (UIComponent)this.getFacets().get(FIRST_FACET_NAME);
    }

    public void setLast(UIComponent last) {
        this.getFacets().put(LAST_FACET_NAME, last);
    }

    public UIComponent getLast() {
        return (UIComponent)this.getFacets().get(LAST_FACET_NAME);
    }

    public void setNext(UIComponent next) {
        this.getFacets().put(NEXT_FACET_NAME, next);
    }

    public UIComponent getNext() {
        return (UIComponent)this.getFacets().get(NEXT_FACET_NAME);
    }

    public void setFastForward(UIComponent previous) {
        this.getFacets().put(FAST_FORWARD_FACET_NAME, previous);
    }

    public UIComponent getFastForward() {
        return (UIComponent)this.getFacets().get(FAST_FORWARD_FACET_NAME);
    }

    public void setFastRewind(UIComponent previous) {
        this.getFacets().put(FAST_REWIND_FACET_NAME, previous);
    }

    public UIComponent getFastRewind() {
        return (UIComponent)this.getFacets().get(FAST_REWIND_FACET_NAME);
    }

    public void setPrevious(UIComponent previous) {
        this.getFacets().put(PREVIOUS_FACET_NAME, previous);
    }

    public UIComponent getPrevious() {
        return (UIComponent)this.getFacets().get(PREVIOUS_FACET_NAME);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public MethodBinding getAction() {
        return null;
    }

    public void setAction(MethodBinding action) {
        throw new UnsupportedOperationException("defining an action is not supported. use an actionlistener");
    }

    public void setActionListener(MethodBinding actionListener) {
        this._actionListener = actionListener;
    }

    public MethodBinding getActionListener() {
        return this._actionListener;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(class$javax$faces$event$ActionListener == null ? (class$javax$faces$event$ActionListener = HtmlDataScroller.class$("javax.faces.event.ActionListener")) : class$javax$faces$event$ActionListener);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public HtmlDataScroller() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setFor(String forValue) {
        this._for = forValue;
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFastStep(int fastStep) {
        this._fastStep = new Integer(fastStep);
    }

    public int getFastStep() {
        if (this._fastStep != null) {
            return this._fastStep;
        }
        ValueBinding vb = this.getValueBinding("fastStep");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Integer.MIN_VALUE;
    }

    public void setPageIndexVar(String pageIndexVar) {
        this._pageIndexVar = pageIndexVar;
    }

    public String getPageIndexVar() {
        if (this._pageIndexVar != null) {
            return this._pageIndexVar;
        }
        ValueBinding vb = this.getValueBinding("pageIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPageCountVar(String pageCountVar) {
        this._pageCountVar = pageCountVar;
    }

    public String getPageCountVar() {
        if (this._pageCountVar != null) {
            return this._pageCountVar;
        }
        ValueBinding vb = this.getValueBinding("pageCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRowsCountVar(String rowsCountVar) {
        this._rowsCountVar = rowsCountVar;
    }

    public String getRowsCountVar() {
        if (this._rowsCountVar != null) {
            return this._rowsCountVar;
        }
        ValueBinding vb = this.getValueBinding("rowsCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setDisplayedRowsCountVar(String displayedRowsCountVar) {
        this._displayedRowsCountVar = displayedRowsCountVar;
    }

    public String getDisplayedRowsCountVar() {
        if (this._displayedRowsCountVar != null) {
            return this._displayedRowsCountVar;
        }
        ValueBinding vb = this.getValueBinding("displayedRowsCountVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFirstRowIndexVar(String firstRowIndexVar) {
        this._firstRowIndexVar = firstRowIndexVar;
    }

    public String getFirstRowIndexVar() {
        if (this._firstRowIndexVar != null) {
            return this._firstRowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("firstRowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setLastRowIndexVar(String lastRowIndexVar) {
        this._lastRowIndexVar = lastRowIndexVar;
    }

    public String getLastRowIndexVar() {
        if (this._lastRowIndexVar != null) {
            return this._lastRowIndexVar;
        }
        ValueBinding vb = this.getValueBinding("lastRowIndexVar");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyle(String style) {
        this._style = style;
    }

    public String getStyle() {
        if (this._style != null) {
            return this._style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public String getStyleClass() {
        if (this._styleClass != null) {
            return this._styleClass;
        }
        ValueBinding vb = this.getValueBinding("styleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginator(boolean paginator) {
        this._paginator = paginator;
    }

    public boolean isPaginator() {
        if (this._paginator != null) {
            return this._paginator;
        }
        ValueBinding vb = this.getValueBinding("paginator");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setPaginatorMaxPages(int paginatorMaxPages) {
        this._paginatorMaxPages = new Integer(paginatorMaxPages);
    }

    public int getPaginatorMaxPages() {
        if (this._paginatorMaxPages != null) {
            return this._paginatorMaxPages;
        }
        ValueBinding vb = this.getValueBinding("paginatorMaxPages");
        Integer v = vb != null ? (Integer)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : Integer.MIN_VALUE;
    }

    public void setPaginatorTableClass(String paginatorTableClass) {
        this._paginatorTableClass = paginatorTableClass;
    }

    public String getPaginatorTableClass() {
        if (this._paginatorTableClass != null) {
            return this._paginatorTableClass;
        }
        ValueBinding vb = this.getValueBinding("paginatorTableClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorTableStyle(String paginatorTableStyle) {
        this._paginatorTableStyle = paginatorTableStyle;
    }

    public String getPaginatorTableStyle() {
        if (this._paginatorTableStyle != null) {
            return this._paginatorTableStyle;
        }
        ValueBinding vb = this.getValueBinding("paginatorTableStyle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorColumnClass(String paginatorColumnClass) {
        this._paginatorColumnClass = paginatorColumnClass;
    }

    public String getPaginatorColumnClass() {
        if (this._paginatorColumnClass != null) {
            return this._paginatorColumnClass;
        }
        ValueBinding vb = this.getValueBinding("paginatorColumnClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorColumnStyle(String paginatorColumnStyle) {
        this._paginatorColumnStyle = paginatorColumnStyle;
    }

    public String getPaginatorColumnStyle() {
        if (this._paginatorColumnStyle != null) {
            return this._paginatorColumnStyle;
        }
        ValueBinding vb = this.getValueBinding("paginatorColumnStyle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorActiveColumnClass(String paginatorActiveColumnClass) {
        this._paginatorActiveColumnClass = paginatorActiveColumnClass;
    }

    public String getPaginatorActiveColumnClass() {
        if (this._paginatorActiveColumnClass != null) {
            return this._paginatorActiveColumnClass;
        }
        ValueBinding vb = this.getValueBinding("paginatorActiveColumnClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorRenderLinkForActive(boolean paginatorRenderLinkForActive) {
        this._paginatorRenderLinkForActive = paginatorRenderLinkForActive;
    }

    public boolean isPaginatorRenderLinkForActive() {
        if (this._paginatorRenderLinkForActive != null) {
            return this._paginatorRenderLinkForActive;
        }
        ValueBinding vb = this.getValueBinding("paginatorRenderLinkForActive");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setFirstStyleClass(String firstStyleClass) {
        this._firstStyleClass = firstStyleClass;
    }

    public String getFirstStyleClass() {
        if (this._firstStyleClass != null) {
            return this._firstStyleClass;
        }
        ValueBinding vb = this.getValueBinding("firstStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setLastStyleClass(String lastStyleClass) {
        this._lastStyleClass = lastStyleClass;
    }

    public String getLastStyleClass() {
        if (this._lastStyleClass != null) {
            return this._lastStyleClass;
        }
        ValueBinding vb = this.getValueBinding("lastStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPreviousStyleClass(String previousStyleClass) {
        this._previousStyleClass = previousStyleClass;
    }

    public String getPreviousStyleClass() {
        if (this._previousStyleClass != null) {
            return this._previousStyleClass;
        }
        ValueBinding vb = this.getValueBinding("previousStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setNextStyleClass(String nextStyleClass) {
        this._nextStyleClass = nextStyleClass;
    }

    public String getNextStyleClass() {
        if (this._nextStyleClass != null) {
            return this._nextStyleClass;
        }
        ValueBinding vb = this.getValueBinding("nextStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFastfStyleClass(String fastfStyleClass) {
        this._fastfStyleClass = fastfStyleClass;
    }

    public String getFastfStyleClass() {
        if (this._fastfStyleClass != null) {
            return this._fastfStyleClass;
        }
        ValueBinding vb = this.getValueBinding("fastfStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setFastrStyleClass(String fastrStyleClass) {
        this._fastrStyleClass = fastrStyleClass;
    }

    public String getFastrStyleClass() {
        if (this._fastrStyleClass != null) {
            return this._fastrStyleClass;
        }
        ValueBinding vb = this.getValueBinding("fastrStyleClass");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPaginatorActiveColumnStyle(String paginatorActiveColumnStyle) {
        this._paginatorActiveColumnStyle = paginatorActiveColumnStyle;
    }

    public String getPaginatorActiveColumnStyle() {
        if (this._paginatorActiveColumnStyle != null) {
            return this._paginatorActiveColumnStyle;
        }
        ValueBinding vb = this.getValueBinding("paginatorActiveColumnStyle");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setRenderFacetsIfSinglePage(boolean renderFacetsIfSinglePage) {
        this._renderFacetsIfSinglePage = renderFacetsIfSinglePage;
    }

    public boolean isRenderFacetsIfSinglePage() {
        if (this._renderFacetsIfSinglePage != null) {
            return this._renderFacetsIfSinglePage;
        }
        ValueBinding vb = this.getValueBinding("renderFacetsIfSinglePage");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
    }

    public boolean isImmediate() {
        if (this._immediate != null) {
            return this._immediate;
        }
        ValueBinding vb = this.getValueBinding("immediate");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setOnclick(String onclick) {
        this._onclick = onclick;
    }

    public String getOnclick() {
        if (this._onclick != null) {
            return this._onclick;
        }
        ValueBinding vb = this.getValueBinding("onclick");
        return vb == null ? null : _ComponentUtils.getStringValue(this.getFacesContext(), vb);
    }

    public void setOndblclick(String ondblclick) {
        this._ondblclick = ondblclick;
    }

    public String getOndblclick() {
        if (this._ondblclick != null) {
            return this._ondblclick;
        }
        ValueBinding vb = this.getValueBinding("ondblclick");
        return vb == null ? null : _ComponentUtils.getStringValue(this.getFacesContext(), vb);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._for, this._fastStep, this._pageIndexVar, this._pageCountVar, this._rowsCountVar, this._displayedRowsCountVar, this._firstRowIndexVar, this._lastRowIndexVar, this._style, this._styleClass, this._columnClasses, this._paginator, this._paginatorMaxPages, this._paginatorTableClass, this._paginatorTableStyle, this._paginatorColumnClass, this._paginatorColumnStyle, this._paginatorActiveColumnClass, this._paginatorActiveColumnStyle, this._paginatorRenderLinkForActive, this._firstStyleClass, this._lastStyleClass, this._previousStyleClass, this._nextStyleClass, this._fastfStyleClass, this._fastrStyleClass, this._renderFacetsIfSinglePage, this._immediate, this._onclick, this._ondblclick, HtmlDataScroller.saveAttachedState((FacesContext)context, (Object)this._actionListener)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
        this._fastStep = (Integer)values[2];
        this._pageIndexVar = (String)values[3];
        this._pageCountVar = (String)values[4];
        this._rowsCountVar = (String)values[5];
        this._displayedRowsCountVar = (String)values[6];
        this._firstRowIndexVar = (String)values[7];
        this._lastRowIndexVar = (String)values[8];
        this._style = (String)values[9];
        this._styleClass = (String)values[10];
        this._columnClasses = (String)values[11];
        this._paginator = (Boolean)values[12];
        this._paginatorMaxPages = (Integer)values[13];
        this._paginatorTableClass = (String)values[14];
        this._paginatorTableStyle = (String)values[15];
        this._paginatorColumnClass = (String)values[16];
        this._paginatorColumnStyle = (String)values[17];
        this._paginatorActiveColumnClass = (String)values[18];
        this._paginatorActiveColumnStyle = (String)values[19];
        this._paginatorRenderLinkForActive = (Boolean)values[20];
        this._firstStyleClass = (String)values[21];
        this._lastStyleClass = (String)values[22];
        this._previousStyleClass = (String)values[23];
        this._nextStyleClass = (String)values[24];
        this._fastfStyleClass = (String)values[25];
        this._fastrStyleClass = (String)values[26];
        this._renderFacetsIfSinglePage = (Boolean)values[27];
        this._immediate = (Boolean)values[28];
        this._onclick = (String)values[29];
        this._ondblclick = (String)values[30];
        this._actionListener = (MethodBinding)HtmlDataScroller.restoreAttachedState((FacesContext)context, (Object)values[31]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

